/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.calculate;

import com.cognos.pogo.monitoring.jmx.MBeanRepository;
import com.cognos.pogo.monitoring.jmx.calculate.Calculation;
import com.cognos.pogo.monitoring.jmx.calculate.CalculationMilliRatio;
import com.cognos.pogo.monitoring.jmx.calculate.CalculationMinuteRatio;
import com.cognos.pogo.monitoring.jmx.calculate.CalculationPercentage;
import com.cognos.pogo.monitoring.jmx.calculate.CalculationRatio;
import com.cognos.pogo.monitoring.jmx.calculate.CalculationSum;
import com.cognos.pogo.monitoring.jmx.calculate.ConcreteMBean;
import com.cognos.pogo.monitoring.jmx.proxy.NotifyingDynamicMBean;
import com.cognos.pogo.monitoring.jmx.proxy.UpdateGroupsInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.ReflectionException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class CalculateMetricsDecorator
extends NotificationBroadcasterSupport
implements NotifyingDynamicMBean,
NotificationEmitter,
NotificationListener,
UpdateGroupsInterface {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(CalculateMetricsDecorator.class.getName());
    private static final Double ONE_HUNDRED_PERCENT = new Double(1.0);
    private static final Double ZERO_PERCENT = new Double(0.0);
    private HashMap<String, Calculation> calculationMap = new HashMap();
    private HashMap<String, Set<Calculation>> attributeMap = new HashMap();
    private int sequenceNumber;
    final ConcreteMBean consolidator;
    private HashSet<String> consolidatedAttributes = new HashSet();
    private MBeanInfo mBeanInfo;

    public CalculateMetricsDecorator(ConcreteMBean consolidator) {
        this.consolidator = consolidator;
        this.setAttributeInfo();
        this.consolidator.addNotificationListener(this, null, null);
    }

    private void setup() {
        this.createPercentCalc("FailedRequestPercent", "NumberOfFailedRequests", "NumberOfSuccessfulRequests", ZERO_PERCENT);
        this.createPercentCalc("SuccessfulRequestPercent", "NumberOfSuccessfulRequests", "NumberOfFailedRequests", ONE_HUNDRED_PERCENT);
        this.createSumCalc("NumberOfProcessedRequests", "NumberOfSuccessfulRequests", "NumberOfFailedRequests");
        this.createMinuteRatioCalc("SuccessfulRequestsPerMinute", "NumberOfSuccessfulRequests", "ServiceTimeSuccessfulRequests");
        this.createRatioCalc("MillisecondsPerSuccessfulRequest", "ServiceTimeSuccessfulRequests", "NumberOfSuccessfulRequests");
        this.createRatioCalc("AverageTimeInQueue", "TimeInQueue", "NumberOfRequests");
        this.createRatioCalc("AverageTimeInThreadQueue", "TimeInThreadQueue", "NumberOfThreadRequests");
    }

    public void setAttributeInfo() {
        MBeanInfo beanInfo = this.consolidator.getMBeanInfo();
        MBeanAttributeInfo[] attributeInfos = beanInfo.getAttributes();
        for (int i = 0; i < attributeInfos.length; ++i) {
            this.consolidatedAttributes.add(attributeInfos[i].getName());
        }
        this.setup();
        MBeanAttributeInfo[] allInfos = this.createMBeanAttributeInfo(attributeInfos);
        this.mBeanInfo = new MBeanInfo(this.getClass().getName(), "description", allInfos, beanInfo.getConstructors(), beanInfo.getOperations(), beanInfo.getNotifications());
    }

    private void createPercentCalc(String resultAttribute, String attribute1, String attribute2, Object undefinedValue) {
        if (this.consolidatedAttributes.contains(attribute1) && this.consolidatedAttributes.contains(attribute2)) {
            CalculationPercentage percentCalc = new CalculationPercentage(this.consolidator, resultAttribute, attribute1, attribute2, undefinedValue);
            this.addCalculationToMaps(resultAttribute, attribute1, attribute2, percentCalc);
        }
    }

    private void createSumCalc(String resultAttribute, String attribute1, String attribute2) {
        if (this.consolidatedAttributes.contains(attribute1) && this.consolidatedAttributes.contains(attribute2)) {
            CalculationSum sumCalc = new CalculationSum(this.consolidator, resultAttribute, attribute1, attribute2);
            this.addCalculationToMaps(resultAttribute, attribute1, attribute2, sumCalc);
        }
    }

    private void createRatioCalc(String resultAttribute, String attribute1, String attribute2) {
        if (this.consolidatedAttributes.contains(attribute1) && this.consolidatedAttributes.contains(attribute2)) {
            CalculationRatio ratio = new CalculationRatio(this.consolidator, resultAttribute, attribute1, attribute2);
            this.addCalculationToMaps(resultAttribute, attribute1, attribute2, ratio);
        }
    }

    private void createMinuteRatioCalc(String resultAttribute, String attribute1, String attribute2) {
        if (this.consolidatedAttributes.contains(attribute1) && this.consolidatedAttributes.contains(attribute2)) {
            CalculationMinuteRatio ratio = new CalculationMinuteRatio(this.consolidator, resultAttribute, attribute1, attribute2);
            this.addCalculationToMaps(resultAttribute, attribute1, attribute2, ratio);
        }
    }

    private void createMilliRatioCalc(String resultAttribute, String attribute1, String attribute2) {
        if (this.consolidatedAttributes.contains(attribute1) && this.consolidatedAttributes.contains(attribute2)) {
            CalculationMilliRatio ratio = new CalculationMilliRatio(this.consolidator, resultAttribute, attribute1, attribute2);
            this.addCalculationToMaps(resultAttribute, attribute1, attribute2, ratio);
        }
    }

    private void addCalculationToMaps(String resultAttribute, String attribute1, String attribute2, Calculation calculation) {
        this.calculationMap.put(resultAttribute, calculation);
        this.addCalculationToAttributeSet(calculation, attribute1);
        this.addCalculationToAttributeSet(calculation, attribute2);
    }

    private void addCalculationToAttributeSet(Calculation calculation, String attribute1) {
        Set<Calculation> attributeCalculation = this.attributeMap.get(attribute1);
        if (attributeCalculation == null) {
            attributeCalculation = new HashSet<Calculation>();
            this.attributeMap.put(attribute1, attributeCalculation);
        }
        attributeCalculation.add(calculation);
    }

    public MBeanAttributeInfo[] createMBeanAttributeInfo(MBeanAttributeInfo[] consolidatedInfos) {
        HashMap<String, MBeanAttributeInfo> attributeHash = new HashMap<String, MBeanAttributeInfo>();
        for (int i = 0; i < consolidatedInfos.length; ++i) {
            attributeHash.put(consolidatedInfos[i].getName(), consolidatedInfos[i]);
        }
        for (Map.Entry<String, Calculation> calcEntry : this.calculationMap.entrySet()) {
            Calculation calc = calcEntry.getValue();
            if (!calc.attributesAreIn(this.attributeMap)) continue;
            MBeanAttributeInfo info = new MBeanAttributeInfo(calcEntry.getKey(), calc.getReturnType(), "Calculated", true, false, false);
            attributeHash.put(calcEntry.getKey(), info);
        }
        return attributeHash.values().toArray(new MBeanAttributeInfo[attributeHash.size()]);
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object calculatedAttribute = this.getCalculatedAttribute(attribute);
        if (calculatedAttribute == null) {
            return this.consolidator.getAttribute(attribute);
        }
        return calculatedAttribute;
    }

    private Object getCalculatedAttribute(String attribute) {
        Calculation calc = this.calculationMap.get(attribute);
        if (calc == null) {
            return null;
        }
        return calc.execute();
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        ArrayList<String> otherAttributes = new ArrayList<String>();
        AttributeList calcAttrList = new AttributeList(attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            Object result = this.getCalculatedAttribute(attributes[i]);
            if (result != null) {
                calcAttrList.add(new Attribute(attributes[i], result));
                continue;
            }
            otherAttributes.add(attributes[i]);
        }
        String[] otherAttrArray = otherAttributes.toArray(new String[otherAttributes.size()]);
        AttributeList consolidatedAttrs = this.consolidator.getAttributes(otherAttrArray);
        calcAttrList.addAll(consolidatedAttrs);
        return calcAttrList;
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        AttributeChangeNotification acn;
        String attributeName;
        Set<Calculation> calcSet;
        if (notification instanceof AttributeChangeNotification && (calcSet = this.attributeMap.get(attributeName = (acn = (AttributeChangeNotification)notification).getAttributeName())) != null) {
            this.sendCalculatedNotifications(calcSet);
        }
        this.sendNotification(notification);
    }

    private void sendCalculatedNotifications(Set<?> calcSet) {
        for (Calculation calculation : calcSet) {
            AttributeChangeNotification newNotification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "CalculatedMetric changed", calculation.getAttributeName(), "String", null, calculation.execute());
            this.sendNotification(newNotification);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mBeanInfo;
    }

    @Override
    public Object invoke(String method, Object[] arguments, String[] params) throws MBeanException, ReflectionException {
        return this.consolidator.invoke(method, arguments, params);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    @Override
    public void updateGroups(MBeanRepository repository) {
        if (this.consolidator instanceof UpdateGroupsInterface) {
            UpdateGroupsInterface update = (UpdateGroupsInterface)((Object)this.consolidator);
            update.updateGroups(repository);
        }
    }

    public ConcreteMBean getWrappedMBeanForTesting() {
        return this.consolidator;
    }
}

