/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.dump;

import com.cognos.pogo.monitoring.jmx.dump.MBeanConfigurationChangeInterface;
import com.cognos.pogo.util.threads.SafeTimerTask;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ConfigFileWatcher {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ConfigFileWatcher.class.getName());
    private ConfigWatcher configWatcher = null;
    private Timer timer = new Timer(true);
    private MBeanConfigurationChangeInterface mbeanConfigInterface;

    public void startWatchingConfigFile(long checkInterval, String filename, MBeanConfigurationChangeInterface mbeanConfigInterface) {
        if (this.configWatcher != null || checkInterval == 0L) {
            return;
        }
        this.mbeanConfigInterface = mbeanConfigInterface;
        this.configWatcher = new ConfigWatcher(filename);
        this.timer.schedule((TimerTask)this.configWatcher, 0L, checkInterval);
    }

    public void setTimerForTesting(Timer timer) {
        this.timer = timer;
    }

    class ConfigWatcher
    extends SafeTimerTask {
        private File configFile;
        long tLastModified;

        ConfigWatcher(String filename) {
            cat.debug("watching file " + filename);
            this.configFile = new File(filename);
            this.tLastModified = 0L;
        }

        @Override
        public void safeRun() {
            long tCurrent = this.configFile.lastModified();
            if (this.tLastModified != tCurrent) {
                this.tLastModified = tCurrent;
                cat.debug("config file changed, reconfiguring dumping");
                ConfigFileWatcher.this.mbeanConfigInterface.configurationChange();
            }
        }
    }
}

