/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.dump;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class MBeanDumpConfig {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(MBeanDumpConfig.class.getName());
    private String filename = "../logs/metricdump.xml";
    private String[] mbeans = new String[]{MBeanUtils.buildObjectName("type=Metrics,*")};
    private long interval = 300000L;
    private long limitCount = -1L;
    private long limitSize = 10000000L;
    private long limitRollover = 0L;
    private boolean resetAfterDump = false;

    public void read(String configfilename) throws FileNotFoundException, DocumentException {
        File file = new File(configfilename);
        FileInputStream inputStream = new FileInputStream(file);
        this.parseConfig(inputStream);
        this.checkValidMetricLogFile(CCLConfigurationFactory.getInstance().resolveEffectivePath(this.getFilename()));
    }

    void parseConfig(InputStream config) throws DocumentException {
        SAXReader reader = new SAXReader();
        Document document = reader.read(config);
        Element rootElement = document.getRootElement();
        Element filenamenode = rootElement.element("filename");
        if (filenamenode != null) {
            this.setFilename(filenamenode.getTextTrim());
        }
        this.getMbeans(rootElement);
        Element intervalElement = rootElement.element("interval");
        this.setInterval(this.getLongFromElement(intervalElement, this.getInterval()));
        Element resetAfterDumpElement = rootElement.element("resetAfterDump");
        this.setResetAfterDump(this.getBooleanFromElement(resetAfterDumpElement, this.getResetAfterDump()));
        Element limitElement = rootElement.element("limit");
        if (limitElement != null) {
            Element limitCountElement = limitElement.element("count");
            this.setLimitCount(this.getLongFromElement(limitCountElement, this.getLimitCount()));
            Element limitSizeElement = limitElement.element("filesize");
            this.setLimitSize(this.getLongFromElement(limitSizeElement, this.getLimitSize()));
            Element limitRolloverElement = limitElement.element("rollover");
            this.setLimitRollover(this.getLongFromElement(limitRolloverElement, this.getLimitRollover()));
        }
    }

    protected void checkValidMetricLogFile(String path) throws FileNotFoundException {
        File outputFile = new File(path);
        File outputDir = outputFile.getParentFile();
        if (!outputDir.exists()) {
            cat.debug("No such Directory: " + outputDir.getAbsolutePath());
            throw new FileNotFoundException("No such Directory: " + outputDir.getAbsolutePath());
        }
    }

    private boolean getBooleanFromElement(Element element, boolean defaultBoolean) {
        if (element == null) {
            return defaultBoolean;
        }
        String text = element.getTextTrim();
        return Boolean.valueOf(text);
    }

    private long getLongFromElement(Element element, long defaultLong) {
        if (element == null) {
            return defaultLong;
        }
        String intervalStr = element.getTextTrim();
        try {
            return Long.parseLong(intervalStr);
        }
        catch (NumberFormatException e) {
            return defaultLong;
        }
    }

    private void getMbeans(Element rootElement) {
        ArrayList<String> mBeanList = new ArrayList<String>();
        Element mbeanElement = rootElement.element("mbeans");
        if (mbeanElement == null) {
            return;
        }
        Iterator mbeanIter = mbeanElement.elementIterator("mbean");
        while (mbeanIter.hasNext()) {
            Element element = (Element)mbeanIter.next();
            String mbean = element.getTextTrim();
            mbean = MBeanUtils.replaceJmxDomainWithCurrent(mbean);
            mBeanList.add(mbean);
        }
        this.mbeans = mBeanList.toArray(new String[mBeanList.size()]);
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void setLimitCount(long limitCount) {
        this.limitCount = limitCount;
    }

    public void setLimitSize(long limitSize) {
        this.limitSize = limitSize;
    }

    public void setMbeans(String[] mbeans) {
        this.mbeans = mbeans;
    }

    public String getFilename() {
        return this.filename;
    }

    public long getInterval() {
        return this.interval;
    }

    public long getLimitCount() {
        return this.limitCount;
    }

    public long getLimitSize() {
        return this.limitSize;
    }

    public String[] getMbeans() {
        return this.mbeans;
    }

    public long getLimitRollover() {
        return this.limitRollover;
    }

    public void setLimitRollover(long limitRollover) {
        this.limitRollover = limitRollover;
    }

    public boolean getResetAfterDump() {
        return this.resetAfterDump;
    }

    public void setResetAfterDump(boolean resetAfterDump) {
        this.resetAfterDump = resetAfterDump;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MBeanDumpConfig) {
            MBeanDumpConfig other = (MBeanDumpConfig)obj;
            return this.filename.equals(other.filename) && this.interval == other.interval && this.limitCount == other.limitCount && this.limitSize == other.limitSize && this.limitRollover == other.limitRollover && this.resetAfterDump == other.resetAfterDump && Arrays.equals(this.mbeans, other.mbeans);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

