/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.dump;

import com.cognos.pogo.monitoring.jmx.dump.OutputFile;
import java.io.BufferedWriter;
import java.io.IOException;
import javax.management.Attribute;
import javax.management.ObjectName;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public abstract class MBeanDumpOutputter {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(MBeanDumpOutputter.class.getName());
    protected BufferedWriter writer;
    private OutputFile outputFile;

    abstract void putMBean(ObjectName var1) throws IOException;

    abstract void putAttribute(Attribute var1) throws IOException;

    abstract void beginDump() throws IOException;

    abstract void endDump() throws IOException;

    public abstract void start() throws IOException;

    public abstract void terminate() throws IOException;

    public void setWriter(BufferedWriter outputStream) {
        this.writer = outputStream;
    }

    public void setFilename(String filename) {
        try {
            if (this.outputFile != null) {
                this.closeFile();
            }
            this.outputFile = new OutputFile(filename);
            this.setWriter(this.outputFile.getStream());
            this.start();
        }
        catch (IOException e) {
            cat.error("Exception setting MBeanDump filename", (Throwable)e);
        }
    }

    private void closeFile() throws IOException {
        this.terminate();
        this.outputFile.close();
    }

    public void checkRollover(long maxFilesize, long rolloverLimit) throws IOException {
        if (this.outputFile.isOverLimit(maxFilesize)) {
            try {
                this.closeFile();
            }
            catch (IOException e) {
                cat.warn("IOException closing Metric dump file ignored", (Throwable)e);
            }
            this.outputFile.doRollover(rolloverLimit);
            this.setWriter(this.outputFile.getStream());
            this.start();
        }
    }
}

