/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.dump;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.log4j.RollingFileAppender;

public class OutputFile {
    private File outputFile;
    private BufferedWriter outputWriter;
    private String path;
    private RollingFileAppender rollingFileAppender;

    public OutputFile(String filename) {
        this.path = CCLConfigurationFactory.getInstance().resolveEffectivePath(filename);
        this.outputFile = new File(this.path);
        this.rollingFileAppender = new OutputRollingFileAppender();
    }

    public synchronized BufferedWriter getStream() throws IOException {
        if (this.outputWriter == null) {
            this.outputWriter = new BufferedWriter(new FileWriter(this.outputFile));
        }
        return this.outputWriter;
    }

    public void close() throws IOException {
        this.outputWriter.close();
        this.outputWriter = null;
    }

    public long length() {
        return this.outputFile.length();
    }

    public boolean isOverLimit(long maxFilesize) {
        long filelength = this.outputFile.length();
        return maxFilesize != 0L && filelength >= maxFilesize;
    }

    public void doRollover(long rolloverLimit) {
        this.rollingFileAppender.setMaxBackupIndex((int)rolloverLimit);
    }

    private final class OutputRollingFileAppender
    extends RollingFileAppender {
        public OutputRollingFileAppender() {
            this.setupLogging();
        }

        private void setupLogging() {
        }
    }
}

