/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.ping;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.monitoring.jmx.ping.PingThread;
import com.cognos.pogo.monitoring.jmx.ping.PingThreadFactory;
import com.cognos.pogo.monitoring.jmx.ping.ProxyResetter;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.threads.SafeTimerTask;
import com.cognos.pogo.util.timer.PogoTimeoutController;
import org.apache.commons.httpclient.util.TimeoutController;

public class PingTask
extends SafeTimerTask {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private static final int DEFAULT_PING_INTERVAL = 30000;
    private long pingInterval = 30000L;
    private PogoTimeoutController timeoutController = new PogoTimeoutController();
    private DispatcherList dispatcherList;
    private PingThreadFactory pingThreadFactory;
    private ProxyResetter proxyResetter;

    public PingTask(DispatcherList dispatcherList, ProxyResetter proxyResetter) {
        this(dispatcherList, proxyResetter, new PingThreadFactory());
    }

    public PingTask(DispatcherList dispatcherList, ProxyResetter proxyResetter, PingThreadFactory pingThreadFactory) {
        this.dispatcherList = dispatcherList;
        this.proxyResetter = proxyResetter;
        this.pingThreadFactory = pingThreadFactory;
    }

    @Override
    public void safeRun() {
        DispatcherListElement changed = null;
        for (DispatcherListElement dle : this.dispatcherList.getCompleteDispatcherListElements()) {
            boolean nodeAvailable = this.checkNode(dle.getNodeID());
            if (dle.isAvailable() && !nodeAvailable) {
                dle.setAvailable(false);
                changed = dle;
                continue;
            }
            if (dle.isAvailable() || !nodeAvailable) continue;
            dle.setAvailable(true);
            changed = dle;
        }
        if (changed != null) {
            cat.info("Dispatcher " + changed.getNodeID() + " changed to " + (changed.isAvailable() ? "available" : "unavailable"));
            cat.info("proxyMBeans reset");
            this.proxyResetter.resetProxyMBeans(this.dispatcherList);
        }
    }

    private boolean checkNode(NodeID nodeID) {
        try {
            PingThread pingThread = this.pingThreadFactory.getInstance(nodeID);
            this.timeoutController.execute(pingThread, this.pingInterval);
            if (pingThread.getException() != null) {
                cat.debug("Failed ping on node: ", nodeID);
                return false;
            }
        }
        catch (TimeoutController.TimeoutException e) {
            cat.debug("Ping timeout on node: ", nodeID);
            return false;
        }
        return true;
    }
}

