/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.proxy;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.ServiceHealth;
import com.cognos.pogo.monitoring.jmx.calculate.CalculateMetricsDecorator;
import com.cognos.pogo.monitoring.jmx.calculate.ConcreteMBean;
import com.cognos.pogo.monitoring.jmx.proxy.MBeanCacheFactory;
import com.cognos.pogo.monitoring.jmx.proxy.MBeanTotal;
import com.cognos.pogo.monitoring.jmx.proxy.NotifyingDynamicMBean;
import com.cognos.pogo.monitoring.jmx.proxy.NotifyingMBeanConsolidator;
import com.cognos.pogo.monitoring.jmx.threshold.DispatcherMBeanHealth;
import com.cognos.pogo.monitoring.jmx.threshold.MBeanHealth;
import com.cognos.pogo.monitoring.jmx.threshold.ServiceHealthAddIn;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdManager;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import com.cognos.pogo.util.PogoLogger;
import java.util.HashMap;
import java.util.Set;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ConsolidatedMBeanCreator {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private final ThresholdManager thresholdManager;
    private final String localSearchPath;
    private MBeanServer server;
    private HashMap<String, DynamicMBean> serviceMbeanList = new HashMap();
    private HashMap<String, DynamicMBean> serviceHealthHashMap = new HashMap();
    private String dispatcherName;

    public ConsolidatedMBeanCreator(ThresholdManager thresholdManager, String localSearchPath) {
        this(thresholdManager, localSearchPath, PogoMBeanServer.getInstance().getServer());
    }

    public ConsolidatedMBeanCreator(ThresholdManager thresholdManager, String localSearchPath, MBeanServer server) {
        this.thresholdManager = thresholdManager;
        this.localSearchPath = localSearchPath;
        this.server = server;
        this.dispatcherName = PropertyInserter.getProperty("dispatcher.name");
    }

    public void createConsolidatedMBeans() {
        try {
            Set<ObjectName> objectNameList = this.server.queryNames(MBeanUtils.createObjectNameInstance("*"), null);
            this.generateMetricAndHealthMBeans(objectNameList);
            this.generateDispatcherMBeans();
        }
        catch (JMException e) {
            cat.error("JMX exception while creating consolidated MBeans", e);
        }
    }

    private void generateMetricAndHealthMBeans(Set<?> objectNameList) throws MalformedObjectNameException {
        for (ObjectName name : objectNameList) {
            String service = name.getKeyProperty("service");
            if (!this.shouldCreateHealthMBean(this.serviceHealthHashMap, service)) continue;
            this.addMBeansForService(service);
        }
    }

    private boolean shouldCreateHealthMBean(HashMap<String, DynamicMBean> serviceHealthHashMap, String service) {
        return service != null && !serviceHealthHashMap.containsKey(service);
    }

    private void addMBeansForService(String service) {
        try {
            cat.debug("Creating MBeans for service = ", service);
            this.createHealthMBean(service);
            CalculateMetricsDecorator decorated = this.createDecoratorForService(service);
            ObjectName objectName = this.createMetricsMBean(service, decorated);
            this.createMetricHealth(objectName, decorated, service);
        }
        catch (JMException e) {
            cat.error("Unable to create MBeans for service " + service, e);
        }
    }

    private ObjectName createMetricsMBean(String service, CalculateMetricsDecorator decorated) throws JMException {
        ObjectName objectName = MBeanUtils.createObjectNameInstance("type=Metrics,service=" + service);
        this.server.registerMBean(decorated, objectName);
        this.serviceMbeanList.put(service, decorated);
        return objectName;
    }

    CalculateMetricsDecorator createDecoratorForService(String service) throws MalformedObjectNameException, MBeanException {
        ObjectName[] objectNames = this.getObjectNamesForService(this.server, service);
        NotifyingMBeanConsolidator consolidator = new NotifyingMBeanConsolidator(this.server, objectNames);
        ConcreteMBean instance = this.maybeCacheMBean(consolidator, objectNames);
        return new CalculateMetricsDecorator(instance);
    }

    private ConcreteMBean maybeCacheMBean(NotifyingMBeanConsolidator consolidator, ObjectName[] objectNames) throws MBeanException {
        if (this.containsCacheType(objectNames)) {
            return MBeanCacheFactory.getInstance(consolidator);
        }
        return consolidator;
    }

    private boolean containsCacheType(ObjectName[] objectNames) {
        for (ObjectName objectName : objectNames) {
            String type = objectName.getKeyProperty("type");
            if (type == null || !type.endsWith("Cache")) continue;
            return true;
        }
        return false;
    }

    private void generateDispatcherMBeans() throws JMException {
        ObjectName dispatcherObjectName = MBeanUtils.createObjectNameInstance("type=Metrics,dispatcher=\"" + this.dispatcherName + "\"");
        this.createHealthAddIn(dispatcherObjectName);
        CalculateMetricsDecorator decorator = this.createCalcualtedMetricsDecorator(dispatcherObjectName);
        this.createDispatcherMetricHealth(dispatcherObjectName, decorator, "dispatcher");
        this.createServiceHealthMBean();
        this.createOperationalStatusMBean();
    }

    private CalculateMetricsDecorator createCalcualtedMetricsDecorator(ObjectName dispatcherObjectName) throws JMException {
        MBeanTotal mBeanTotal = new MBeanTotal(this.serviceMbeanList, dispatcherObjectName.toString());
        CalculateMetricsDecorator decorator = new CalculateMetricsDecorator(mBeanTotal);
        this.server.registerMBean(decorator, dispatcherObjectName);
        return decorator;
    }

    private void createHealthAddIn(ObjectName dispatcherObjectName) throws MalformedObjectNameException {
        ServiceHealthAddIn healthAddIn = new ServiceHealthAddIn(this.server, MBeanUtils.getHealthObjectName(dispatcherObjectName));
        this.serviceMbeanList.put("healthAddIn", healthAddIn);
        this.serviceHealthHashMap.put("dispatcherHealth", healthAddIn);
    }

    private void createServiceHealthMBean() throws JMException {
        ServiceHealth serviceHealth = new ServiceHealth(this.serviceHealthHashMap);
        ObjectName serviceHealthName = MBeanUtils.createObjectNameInstance("type=ServiceHealth,dispatcher=\"" + this.dispatcherName + "\"");
        this.server.registerMBean(serviceHealth, serviceHealthName);
    }

    private void createOperationalStatusMBean() throws JMException {
        ServiceHealth operationalStatus = new ServiceHealth(this.serviceMbeanList, "OperationalStatus");
        ObjectName objectName = MBeanUtils.createObjectNameInstance("type=ServiceOperationalStatus,dispatcher=\"" + this.dispatcherName + "\"");
        this.server.registerMBean(operationalStatus, objectName);
    }

    private void createMetricHealth(ObjectName objectName, NotifyingDynamicMBean beanTotal, String service) throws JMException {
        MBeanHealth receiver = new MBeanHealth(this.server.getMBeanInfo(objectName), service);
        this.registerMetricHealth(objectName, beanTotal, receiver);
    }

    private void createDispatcherMetricHealth(ObjectName objectName, NotifyingDynamicMBean beanTotal, String service) throws JMException {
        DispatcherMBeanHealth receiver = new DispatcherMBeanHealth(this.server.getMBeanInfo(objectName), service, beanTotal);
        this.registerMetricHealth(objectName, beanTotal, receiver);
    }

    private void registerMetricHealth(ObjectName objectName, NotifyingDynamicMBean beanTotal, MBeanHealth receiver) throws JMException {
        receiver.setLocalSearchPath(this.localSearchPath);
        this.server.registerMBean(receiver, MBeanUtils.getHealthObjectName(objectName));
        this.thresholdManager.addThresholdReceiver(objectName, receiver, beanTotal);
    }

    private ObjectName[] getObjectNamesForService(MBeanServer server, String service) throws MalformedObjectNameException {
        Set<ObjectName> set = server.queryNames(MBeanUtils.createObjectNameInstance("service=" + service + ",*"), null);
        set.remove(MBeanUtils.createObjectNameInstance("type=Metrics,service=" + service));
        ObjectName[] objectNames = new ObjectName[set.size()];
        set.toArray(objectNames);
        return objectNames;
    }

    private void createHealthMBean(String service) {
        try {
            ObjectName parentObjectName = MBeanUtils.createObjectNameInstance("type=MetricHealth,service=" + service);
            ServiceHealthAddIn serviceHealth = new ServiceHealthAddIn(this.server, parentObjectName);
            ObjectName objectName = MBeanUtils.createObjectNameInstance("type=health,service=" + service);
            this.server.registerMBean(serviceHealth, objectName);
            this.serviceHealthHashMap.put(service, serviceHealth);
        }
        catch (JMException e) {
            cat.error("JMException: ", e);
        }
    }
}

