/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.proxy;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.monitoring.jmx.calculate.ConcreteMBean;
import com.cognos.pogo.util.PogoLogger;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import mx4j.tools.remote.proxy.RemoteMBeanProxy;

public abstract class MBeanCache
implements ConcreteMBean {
    protected static final PogoLogger cat = PogoLogger.getLogger();
    private final DynamicMBean bean;
    private ObjectName objectName;
    private boolean isRemote;
    private MBeanInfo beanInfo;
    private HashSet<String> beanInfoAttributes;
    private String beanCacheName;
    private boolean disableCaching = false;
    private volatile long lastCacheUpdateInMillis = 0L;
    private ConcurrentHashMap<String, Object> attributeCache = new ConcurrentHashMap();
    protected static long DEFAULT_CACHE_EXPIRY_IN_MILLIS = 20000L;
    protected static long cacheExpiryInMillis;
    protected static boolean disableCachingSystemWide;
    private final Lock updateCacheLock = new ReentrantLock();
    CountDownLatch initializingCacheLatch = new CountDownLatch(1);
    protected static final String CACHE_EXPIRY_PROPERTY = "dispatcher.mbean_cache_expiry";

    protected static void initializeStaticParameters(String cacheExpiryProperty) {
        cacheExpiryInMillis = DEFAULT_CACHE_EXPIRY_IN_MILLIS;
        disableCachingSystemWide = false;
        if (cacheExpiryProperty != null) {
            try {
                cacheExpiryInMillis = Long.parseLong(cacheExpiryProperty);
            }
            catch (NumberFormatException ex) {
                cat.error("Invalid MBean cache expiry property value: [", cacheExpiryProperty, "]. Using default value: ", cacheExpiryInMillis, " ms.");
            }
            if (cacheExpiryInMillis <= 0L) {
                disableCachingSystemWide = true;
                cat.warn("MBeanCache has been disabled");
            } else {
                cat.info("MBean cache expiry set to ", cacheExpiryInMillis, " ms.");
            }
        }
    }

    protected MBeanCache(DynamicMBean aBean) throws MBeanException {
        this.bean = aBean;
        this.isRemote = this.bean instanceof RemoteMBeanProxy;
    }

    public void setObjectName(ObjectName aObjectName) {
        this.objectName = aObjectName;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setBeanCacheName(String aName) {
        this.beanCacheName = aName;
    }

    public String getBeanCacheName() {
        return this.beanCacheName;
    }

    protected DynamicMBean getBean() {
        return this.bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MBeanInfo getMBeanInfo() {
        if (disableCachingSystemWide) {
            return null;
        }
        if (this.beanInfo == null) {
            this.beanInfo = this.bean.getMBeanInfo();
            MBeanAttributeInfo[] attributeInfos = this.beanInfo.getAttributes();
            MBeanCache mBeanCache = this;
            synchronized (mBeanCache) {
                this.beanInfoAttributes = new HashSet(attributeInfos.length);
                for (int i = 0; i < attributeInfos.length; ++i) {
                    MBeanAttributeInfo info = attributeInfos[i];
                    String infoName = info.getName();
                    this.beanInfoAttributes.add(infoName);
                }
            }
        }
        return this.beanInfo;
    }

    public void disableCaching() {
        cat.debug(this, ": Caching was disabled");
        this.disableCaching = true;
    }

    public void enableCaching() {
        cat.debug(this, ": Caching was enabled");
        this.disableCaching = false;
    }

    protected boolean isEnabled() {
        return !this.disableCaching && !disableCachingSystemWide && this.isRemote && this.getMBeanInfo() != null;
    }

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.getAttribute(attributeName, true, true);
    }

    private Object getAttribute(String attributeName, boolean performCacheValidation, boolean throwExceptionIfNotFound) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object cachedAttribute;
        if (!this.isEnabled()) {
            cat.debug(this, ".getAttribute(", attributeName, "): caching disabled, retrieving attribute directly from the bean)");
            return this.bean.getAttribute(attributeName);
        }
        if (performCacheValidation) {
            this.validateCache(attributeName);
        }
        Object object = cachedAttribute = attributeName == null ? null : this.attributeCache.get(attributeName);
        if (cachedAttribute != null) {
            cat.debug(this, ".getAttribute(", attributeName, "): returning cached value [", cachedAttribute, "])");
            return cachedAttribute;
        }
        if (throwExceptionIfNotFound) {
            cat.debug(this, ".getAttribute(", attributeName, "): attribute not found in the cache");
            throw new AttributeNotFoundException("Attribute not found: " + attributeName);
        }
        return null;
    }

    private void setAttribute(String attributeName, Object attributeValue) {
        cat.debug(this, ".setAttribute(name [", attributeName, "], value [", attributeValue, "])");
        this.attributeCache.put(attributeName, attributeValue);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        int i;
        if (!this.isEnabled()) {
            return this.bean.getAttributes(attributes);
        }
        if (cat.isDebugEnabled()) {
            StringBuffer msg = new StringBuffer(this.toString()).append(".getAttributes(): attributes = ");
            for (i = 0; i < attributes.length; ++i) {
                msg.append(attributes[i]).append(", ");
            }
            cat.debug(msg.toString());
        }
        AttributeList attrList = new AttributeList();
        for (i = 0; i < attributes.length; ++i) {
            String attrName = attributes[i];
            Object attrValue = null;
            try {
                attrValue = this.getAttribute(attrName, true, false);
            }
            catch (JMException e) {
                cat.debug("getAttribute threw exception ", e);
            }
            if (attrValue == null) continue;
            attrList.add(new Attribute(attrName, attrValue));
        }
        return attrList;
    }

    public int size() {
        return this.attributeCache.size();
    }

    private void validateCache(String attributeName) throws MBeanException {
        if (attributeName == null) {
            cat.debug(this, "isValid(", attributeName, "): No attribute name specified, ignoring. bean name = ", this.objectName);
        } else if (!this.beanInfoAttributes.contains(attributeName)) {
            cat.debug(this, "isValid(", attributeName, "): Attribute is not part of this MBean. Ignoring. bean name = ", this.objectName);
        } else if (this.getCurrentTime() - this.lastCacheUpdateInMillis > cacheExpiryInMillis || !this.attributeCache.containsKey(attributeName)) {
            this.updateCache(attributeName);
        }
    }

    private void updateCache(String attributeName) throws MBeanException {
        if (this.updateCacheLock.tryLock()) {
            try {
                this.retrieveAndSetAttributes(attributeName);
            }
            finally {
                this.notifyUpdateComplete();
                this.updateCacheLock.unlock();
            }
        } else {
            this.waitForCacheInitialization();
        }
    }

    private void notifyUpdateComplete() {
        this.initializingCacheLatch.countDown();
    }

    protected void waitForCacheInitialization() {
        try {
            this.initializingCacheLatch.await();
        }
        catch (InterruptedException e) {
            cat.debug("Wait for cache initialization interrupted", e);
        }
    }

    private void retrieveAndSetAttributes(String attributeName) throws MBeanException {
        if (this.lastCacheUpdateInMillis == 0L) {
            cat.debug(this, ".validateCache(", attributeName, "): populating cache for the first time");
        } else {
            cat.debug(this, ".validateCache(", attributeName, "): cache is stale, refreshing");
        }
        AttributeList attributeList = this.retrieveCacheableAttributes(attributeName);
        if (attributeList != null) {
            this.cleanUp();
            for (Attribute attribute : attributeList) {
                this.setAttribute(attribute.getName(), attribute.getValue());
            }
            this.lastCacheUpdateInMillis = this.getCurrentTime();
        }
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AttributeList retrieveCacheableAttributes(String attributeName) throws MBeanException {
        String[] attributes;
        MBeanCache mBeanCache = this;
        synchronized (mBeanCache) {
            attributes = new String[this.beanInfoAttributes.size()];
            this.beanInfoAttributes.toArray(attributes);
        }
        cat.debug(this, ".validateCache(", attributeName, "): Performing a read-ahead caching. Object name = ", this.objectName);
        return this.bean.getAttributes(attributes);
    }

    public void cleanUp() {
        if (!this.isEnabled()) {
            return;
        }
        cat.debug(this, ".cleanup()");
        this.attributeCache.clear();
    }

    public long getCacheExpire() {
        return cacheExpiryInMillis;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName != null && actionName.equals("reset")) {
            cat.debug(this, ".invoke: reset action, cleaning up the cache");
            this.cleanUp();
        }
        return this.bean.invoke(actionName, params, signature);
    }

    public String toString() {
        return "MBeanCache[" + this.beanCacheName + ", " + this.bean + "]";
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (this.bean instanceof NotificationListener) {
            ((NotificationListener)((Object)this.bean)).handleNotification(notification, handback);
        }
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        if (this.bean instanceof NotificationBroadcaster) {
            ((NotificationBroadcaster)((Object)this.bean)).addNotificationListener(listener, filter, handback);
        }
    }

    static {
        MBeanCache.initializeStaticParameters(PropertyInserter.getProperty(CACHE_EXPIRY_PROPERTY, null));
    }
}

