/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.proxy;

import com.cognos.pogo.monitoring.jmx.aggregator.AttributeAggregator;
import com.cognos.pogo.monitoring.jmx.aggregator.AttributeAggregatorFactory;
import com.cognos.pogo.monitoring.jmx.calculate.ConcreteMBean;
import com.cognos.pogo.monitoring.jmx.proxy.MBeanCache;
import com.cognos.pogo.monitoring.jmx.proxy.MBeanCacheFactory;
import com.cognos.pogo.monitoring.jmx.proxy.MBeanCacheWithCMAttributes;
import com.cognos.pogo.monitoring.jmx.proxy.MBeanCacheWithIsolatedAttributes;
import com.cognos.pogo.monitoring.jmx.proxy.NotifyingDynamicMBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class MBeanTotal
extends NotificationBroadcasterSupport
implements NotifyingDynamicMBean,
NotificationListener,
NotificationEmitter,
ConcreteMBean {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(MBeanTotal.class.getName());
    private MBeanInfo mBeanInfo;
    private AttributeAggregatorFactory attributeAggregatorFactory;
    private final String beanName;
    private HashSet<MBeanCacheWithIsolatedAttributes> beanCacheList = new HashSet();
    private static HashSet<String> persistentMBeans = new HashSet();

    public MBeanTotal(HashMap<String, DynamicMBean> mbeans, String mBeanName) {
        this.beanName = mBeanName;
        if (mbeans != null) {
            this.setupMBeanInfo(mbeans);
        }
    }

    protected void setupMBeanInfo(Map<?, DynamicMBean> mbeanHash) {
        this.createBeanCacheList(mbeanHash);
        this.mBeanInfo = this.getAllMBeanInfo(mbeanHash.values());
        this.attributeAggregatorFactory = new AttributeAggregatorFactory(this.mBeanInfo.getAttributes());
    }

    private void createBeanCacheList(Map<?, DynamicMBean> mbeanHash) {
        this.beanCacheList.clear();
        for (Map.Entry<?, DynamicMBean> entry : mbeanHash.entrySet()) {
            Object key = entry.getKey();
            ObjectName objectName = key instanceof ObjectName ? (ObjectName)key : null;
            String serviceName = key instanceof String ? (String)key : null;
            DynamicMBean dynamicMBean = entry.getValue();
            try {
                String serviceProperty;
                MBeanCacheWithCMAttributes beanCache = MBeanCacheFactory.getInstance(dynamicMBean);
                beanCache.setBeanCacheName("bean: " + this.beanName + ", serviceName: " + serviceName + ", objectName: " + objectName);
                if (cat.isDebugEnabled()) {
                    cat.debug(beanCache + " instantiated.");
                }
                String string = serviceProperty = objectName != null ? objectName.getKeyProperty("service") : null;
                if (persistentMBeans.contains(serviceProperty)) {
                    if (cat.isDebugEnabled()) {
                        cat.debug(beanCache + ": disabling caching for service " + serviceProperty);
                    }
                    beanCache.disableCaching();
                } else {
                    String typeProperty;
                    beanCache.registerAttributeForIsolatedCaching("OperationalStatus");
                    beanCache.registerAttributeForIsolatedCaching("Health");
                    String string2 = typeProperty = objectName != null ? objectName.getKeyProperty("type") : null;
                    if (objectName != null && serviceProperty == null && typeProperty != null && typeProperty.equals("Metrics")) {
                        beanCache.registerAttributeForIsolatedCaching("ServiceTimeSuccessfulRequests");
                        beanCache.registerAttributeForIsolatedCaching("NumberOfSuccessfulRequests");
                        beanCache.registerAttributeForIsolatedCaching("NumberOfFailedRequests");
                        beanCache.registerAttributeForIsolatedCaching("Uptime");
                        beanCache.registerAttributeForIsolatedCaching("NumberOfSessions");
                        beanCache.registerAttributeForIsolatedCaching("NumberOfSessionsHighWaterMark");
                        beanCache.registerAttributeForIsolatedCaching("LastSessionResetTime");
                        beanCache.registerAttributeForIsolatedCaching("NumberOfSessionsHighWaterMarkLastUpdateTime");
                        beanCache.registerAttributeForIsolatedCaching("NumberOfSessionsLowWaterMark");
                        beanCache.registerAttributeForIsolatedCaching("NumberOfSessionsLowWaterMarkLastUpdateTime");
                        beanCache.registerAttributeForIsolatedCaching("LastRequestResetTime");
                        beanCache.registerAttributeForIsolatedCaching("AllRequestsLastUpdateTime");
                        beanCache.registerAttributeForIsolatedCaching("NumberOfFailedRequests");
                        beanCache.registerAttributeForIsolatedCaching("FailedRequestsLastUpdateTime");
                        beanCache.registerAttributeForIsolatedCaching("NumberOfSuccessfulRequests");
                        beanCache.registerAttributeForIsolatedCaching("SuccessfulRequestsLastUpdateTime");
                        beanCache.registerAttributeForIsolatedCaching("ServiceTimeAllRequests");
                        beanCache.registerAttributeForIsolatedCaching("ReceivedRequestsLastUpdateTime");
                        beanCache.registerAttributeForIsolatedCaching("ServiceTimeFailedRequests");
                        beanCache.registerAttributeForIsolatedCaching("ServiceTimeSuccessfulRequests");
                        beanCache.registerAttributeForIsolatedCaching("ResponseTimeHighWaterMark");
                        beanCache.registerAttributeForIsolatedCaching("ResponseTimeHighWaterMarkLastUpdateTime");
                        beanCache.registerAttributeForIsolatedCaching("ResponseTimeLowWaterMark");
                        beanCache.registerAttributeForIsolatedCaching("ResponseTimeLowWaterMarkLastUpdateTime");
                        beanCache.registerAttributeForIsolatedCaching("ConsolidatedLastResponseTime");
                        beanCache.registerAttributeForIsolatedCaching("LastResponseTimeLastUpdateTime");
                    }
                }
                this.beanCacheList.add(beanCache);
            }
            catch (MBeanException e) {
                cat.error("Can't create MBean cache for DynamicMBean", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        void var5_8;
        if (cat.isDebugEnabled()) {
            StringBuffer msg = new StringBuffer("mbean = ");
            msg.append(this.beanName).append(" attribure = ");
            msg.append(attribute);
            cat.debug(msg.toString());
        }
        String savedAttribute = attribute;
        if (attribute.equals("LastResponseTime")) {
            attribute = "ConsolidatedLastResponseTime";
        }
        AttributeAggregator aggregator = this.attributeAggregatorFactory.createAttributeAggregator(attribute);
        for (MBeanCache mBeanCache : this.beanCacheList) {
            try {
                Object attributeObject = mBeanCache.getAttribute(attribute);
                if (attributeObject == null) continue;
                aggregator.combine(attributeObject);
            }
            catch (JMException attributeObject) {}
        }
        Object object = aggregator.getAggregation();
        if (savedAttribute.equals("LastResponseTime")) {
            CompositeData comp = (CompositeData)object;
            Object object2 = comp.get("LastResponseTime");
        }
        return var5_8;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException();
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        if (cat.isDebugEnabled()) {
            StringBuffer msg = new StringBuffer("mbean = ");
            msg.append(this.beanName).append(" attribures = ");
            for (int i = 0; i < attributes.length; ++i) {
                msg.append(attributes[i]).append(" ");
            }
            cat.debug(msg.toString());
        }
        HashMap<String, AttributeAggregator> aggregators = new HashMap<String, AttributeAggregator>();
        String[] consolidatedNames = this.createConsolidatedNames(attributes);
        for (int i = 0; i < attributes.length; ++i) {
            try {
                aggregators.put(consolidatedNames[i], this.attributeAggregatorFactory.createAttributeAggregator(consolidatedNames[i]));
                continue;
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                if (!cat.isInfoEnabled()) continue;
                cat.info("Attribute not found: " + attributes[i] + ", mbean: " + this.beanName);
            }
        }
        for (MBeanCache mBeanCache : this.beanCacheList) {
            try {
                AttributeList list = mBeanCache.getAttributes(consolidatedNames);
                for (int j = 0; j < list.size(); ++j) {
                    Attribute attribute = (Attribute)list.get(j);
                    AttributeAggregator attributeAggregator = (AttributeAggregator)aggregators.get(attribute.getName());
                    if (attributeAggregator == null) continue;
                    attributeAggregator.combine(attribute.getValue());
                }
            }
            catch (Exception e) {
                cat.warn("Caught exception in getAttributes, ignoring MBean: ", (Throwable)e);
            }
        }
        AttributeList attributeList = new AttributeList(attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            AttributeAggregator attributeAggregator = (AttributeAggregator)aggregators.get(consolidatedNames[i]);
            if (attributeAggregator == null) continue;
            Object aggregation = attributeAggregator.getAggregation();
            if (attributes[i].equals("LastResponseTime")) {
                CompositeData comp = (CompositeData)aggregation;
                aggregation = comp.get("LastResponseTime");
            }
            Attribute attr = new Attribute(attributes[i], aggregation);
            attributeList.add(attr);
        }
        return attributeList;
    }

    private String[] createConsolidatedNames(String[] attributes) {
        String[] consolidatedNames = new String[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            consolidatedNames[i] = attributes[i].equals("LastResponseTime") ? "ConsolidatedLastResponseTime" : attributes[i];
        }
        return consolidatedNames;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Object returned = null;
        for (MBeanCache mBeanCache : this.beanCacheList) {
            try {
                returned = mBeanCache.invoke(actionName, params, signature);
            }
            catch (JMException jMException) {}
        }
        Notification notification = new Notification("reset", this, 0L);
        this.sendNotification(notification);
        return returned;
    }

    @Override
    protected void handleNotification(NotificationListener listener, Notification notif, Object handback) {
        super.handleNotification(listener, notif, handback);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mBeanInfo;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.mBeanInfo.getNotifications();
    }

    private MBeanInfo getAllMBeanInfo(Collection<DynamicMBean> mbeanList) {
        HashSet<MBeanFeatureInfo> attrList = new HashSet<MBeanFeatureInfo>();
        ArrayList<MBeanConstructorInfo> constrList = new ArrayList<MBeanConstructorInfo>();
        HashSet<MBeanOperationInfo> opList = new HashSet<MBeanOperationInfo>();
        ArrayList<MBeanNotificationInfo> notifList = new ArrayList<MBeanNotificationInfo>();
        for (DynamicMBean mBean : mbeanList) {
            try {
                MBeanInfo beanInfo = mBean.getMBeanInfo();
                this.mergeAttributes(attrList, beanInfo.getAttributes());
                constrList.addAll(Arrays.asList(beanInfo.getConstructors()));
                this.mergeOperations(opList, beanInfo.getOperations());
                notifList.addAll(Arrays.asList(beanInfo.getNotifications()));
            }
            catch (Exception e) {
                cat.info("Exception getting MBeanInfo ", (Throwable)e);
            }
        }
        MBeanAttributeInfo[] attrInfo = new MBeanAttributeInfo[attrList.size()];
        attrList.toArray(attrInfo);
        MBeanConstructorInfo[] constrInfo = new MBeanConstructorInfo[constrList.size()];
        constrList.toArray(constrInfo);
        MBeanOperationInfo[] operations = new MBeanOperationInfo[opList.size()];
        opList.toArray(operations);
        MBeanNotificationInfo[] notifInfo = new MBeanNotificationInfo[notifList.size()];
        notifList.toArray(notifInfo);
        return new MBeanInfo(this.getClass().getName(), "description", attrInfo, constrInfo, operations, notifInfo);
    }

    private void mergeAttributes(HashSet<MBeanFeatureInfo> attrList, MBeanFeatureInfo[] attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            MBeanFeatureInfo attrInfo = attributes[i];
            attrList.add(attrInfo);
        }
    }

    private void mergeOperations(HashSet<MBeanOperationInfo> opList, MBeanOperationInfo[] attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            MBeanOperationInfo attrInfo = attributes[i];
            opList.add(attrInfo);
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        this.sendNotification(notification);
    }

    static {
        persistentMBeans.add("SMTPQueue");
        persistentMBeans.add("TaskQueue");
        persistentMBeans.add("SMTPBackupQueue");
        persistentMBeans.add("JobQueue");
    }
}

