/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.proxy;

import com.cognos.pogo.monitoring.jmx.MBeanRepository;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.calculate.CalculateMetricsDecorator;
import com.cognos.pogo.monitoring.jmx.proxy.GroupMBeanTotal;
import com.cognos.pogo.monitoring.jmx.threshold.ConsolidatedHealthMBeanCollection;
import com.cognos.pogo.monitoring.jmx.threshold.ServiceHealthAddIn;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import java.util.HashSet;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ServerGroupServices {
    public static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ServerGroupServices.class.getName());
    private final String groupName;
    private final MBeanRepository mBeanRepository;
    private HashSet<String> registeredServices = new HashSet();
    private ConsolidatedHealthMBeanCollection consolidatedHealthMBeanCollection;

    public ServerGroupServices(String groupName, MBeanRepository beanRepository) {
        this.groupName = groupName;
        this.mBeanRepository = beanRepository;
    }

    public void registerServices() throws JMException {
        HashSet<String> services = this.getRegisteredServices();
        for (String serviceName : services) {
            this.registeredServices.add(serviceName);
            this.registerServiceGroupMBeans(serviceName);
        }
    }

    public void syncServices() {
        HashSet<String> currentRegisteredServices = this.getRegisteredServices();
        HashSet<String> registeredServicesCopy = new HashSet<String>(this.registeredServices);
        for (String service : registeredServicesCopy) {
            if (currentRegisteredServices.contains(service)) {
                currentRegisteredServices.remove(service);
                continue;
            }
            this.removeService(service);
        }
        this.addServices(currentRegisteredServices);
    }

    private void registerServiceGroupMBeans(String serviceName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException {
        ObjectName serviceObjectName = this.getObjectNameForService(serviceName);
        ServiceHealthAddIn healthAddIn = new ServiceHealthAddIn(this.getProxyServer(), MBeanUtils.getHealthObjectName(serviceObjectName));
        GroupMBeanTotal serviceGroupMetrics = new GroupMBeanTotal(this.mBeanRepository, serviceObjectName, healthAddIn);
        CalculateMetricsDecorator decorator = new CalculateMetricsDecorator(serviceGroupMetrics);
        this.mBeanRepository.registerMBean(serviceObjectName, decorator);
        this.createMetricHealth(serviceObjectName, decorator);
    }

    private void createMetricHealth(ObjectName serviceObjectName, CalculateMetricsDecorator decorator) {
        if (this.consolidatedHealthMBeanCollection != null) {
            this.consolidatedHealthMBeanCollection.createHealthMBean(serviceObjectName, decorator);
        } else {
            cat.debug("Unable to register Metric Health MBean for " + serviceObjectName);
        }
    }

    private MBeanServer getProxyServer() {
        return PogoMBeanServer.getInstance().getProxyMBeanServer();
    }

    private ObjectName getObjectNameForService(String serviceName) throws MalformedObjectNameException {
        return MBeanUtils.createObjectNameInstance("type=Metrics,group=" + this.groupName + ",service=" + serviceName);
    }

    private HashSet<String> getRegisteredServices() {
        try {
            ObjectName serviceObjectName = MBeanUtils.createObjectNameInstance("type=Metrics,group=" + this.groupName + ",*");
            MBeanRepository groupRepository = this.mBeanRepository.getExpandedDispatchers(serviceObjectName);
            HashSet<String> services = groupRepository.getServices();
            return services;
        }
        catch (MalformedObjectNameException e) {
            cat.debug("unexpected error", (Throwable)e);
            return new HashSet<String>();
        }
    }

    private void addServices(HashSet<String> currentRegisteredServices) {
        for (String service : currentRegisteredServices) {
            this.addService(service);
        }
    }

    private void addService(String service) {
        try {
            this.registerServiceGroupMBeans(service);
        }
        catch (JMException e) {
            cat.info("Unable to register MBeans for group " + this.groupName + " service " + service);
        }
    }

    private void removeService(String service) {
        try {
            ObjectName objectName = this.getObjectNameForService(service);
            this.mBeanRepository.unregisterMBean(objectName);
            this.mBeanRepository.unregisterMBean(MBeanUtils.getHealthObjectName(objectName));
            this.registeredServices.remove(service);
        }
        catch (MalformedObjectNameException e) {
            cat.debug("Unexpected exception ", (Throwable)e);
        }
    }

    public void setConsolidatedHealthMBeanCollection(ConsolidatedHealthMBeanCollection consolidatedHealthMBeanCollection) {
        this.consolidatedHealthMBeanCollection = consolidatedHealthMBeanCollection;
    }
}

