/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.remote;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.util.PogoLogger;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import mx4j.tools.remote.caucho.CauchoInput;
import mx4j.tools.remote.caucho.CauchoOutput;
import mx4j.tools.remote.caucho.CauchoService;
import mx4j.tools.remote.caucho.hessian.HessianServlet;

public class CognosHessianServlet
extends HessianServlet {
    static final long serialVersionUID = 28072006L;
    private static final PogoLogger log = PogoLogger.getLogger();
    private CauchoService nonSSLService;
    private CauchoService sslService;
    private static final String MAX_REQUEST_CONTENT_LENGTH_PROPERTY = "CognosHessianServlet.maxRequestContentLength";
    private static final int MAX_REQUEST_CONTENT_LENGTH_DEFAULT = 100000;
    private static int maxRequestContextLength;

    static void setMaxRequestContentLength() {
        try {
            String contentLength = PropertyInserter.getProperty(MAX_REQUEST_CONTENT_LENGTH_PROPERTY);
            maxRequestContextLength = Integer.parseInt(contentLength);
        }
        catch (Exception e) {
            maxRequestContextLength = 100000;
        }
        log.info("Using maxRequestContextLength=", maxRequestContextLength);
    }

    private synchronized CauchoService getService(String url) {
        if (url.startsWith("https")) {
            if (this.sslService == null) {
                this.sslService = new CauchoService("hessian+ssl");
            }
            return this.sslService;
        }
        if (this.nonSSLService == null) {
            this.nonSSLService = new CauchoService("hessian");
        }
        return this.nonSSLService;
    }

    protected void invoke(HttpServletRequest request, CauchoInput input, CauchoOutput output) throws IOException {
        if (this.isRequestTooBig(request)) {
            this.discardRequest(request);
        } else {
            this.handleRequest(request, input, output);
        }
    }

    private boolean isRequestTooBig(HttpServletRequest request) {
        return request.getContentLength() > maxRequestContextLength;
    }

    private void discardRequest(HttpServletRequest request) {
        log.warn("Ignoring suspiciously large request (", request.getContentLength(), " bytes)");
    }

    private void handleRequest(HttpServletRequest request, CauchoInput input, CauchoOutput output) throws IOException {
        input.startCall();
        Map headers = this.readHeaders(input);
        String methodName = input.readMethod();
        Method method = this.findMethod(methodName);
        if (method == null) {
            output.startReply();
            NoSuchMethodException x = new NoSuchMethodException(methodName);
            output.writeFault((Throwable)x);
            output.completeReply();
        } else {
            Object[] values = this.readArguments(input, method);
            input.completeCall();
            Object result = null;
            try {
                String requestURL = request.getRequestURL().toString();
                result = this.invoke(requestURL, this.getService(requestURL), method, headers, values);
            }
            catch (Throwable x) {
                output.startReply();
                output.writeFault(x);
                output.completeReply();
                return;
            }
            output.startReply();
            output.writeObject(result);
            output.completeReply();
        }
    }

    protected CauchoService createService() {
        return null;
    }

    public void destroy() {
        this.sslService = null;
        this.nonSSLService = null;
    }

    static {
        CognosHessianServlet.setMaxRequestContentLength();
    }
}

