/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.remote.proxy;

import com.cognos.pogo.monitoring.jmx.JMXDispatcherConnection;
import com.cognos.pogo.monitoring.jmx.remote.proxy.PogoRuntimeException;
import com.cognos.pogo.util.PogoLogger;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

public class PogoMBeanServerForwarder
implements MBeanServer {
    private static PogoLogger log = PogoLogger.getLogger();
    private MBeanServer mBeanServer;
    private JMXDispatcherConnection jmxDispatcherConnection;
    private MBeanServerConnection mbeanServerConnection;

    public PogoMBeanServerForwarder() {
        this(MBeanServerFactory.createMBeanServer());
    }

    public PogoMBeanServerForwarder(MBeanServer createMBeanServer) {
        this.mBeanServer = createMBeanServer;
        log.debug("MBean server: ", this.mBeanServer);
    }

    public MBeanServerConnection getMBeanServer() {
        return this.getMbs();
    }

    public void setJmxDispatcherConnection(JMXDispatcherConnection jmxDispatcherConnection) {
        this.jmxDispatcherConnection = jmxDispatcherConnection;
    }

    public void setMBeanServer(MBeanServerConnection mbeanServerConnection) {
        this.mbeanServerConnection = mbeanServerConnection;
    }

    private MBeanServerConnection getMbs() {
        if (this.mbeanServerConnection != null) {
            return this.mbeanServerConnection;
        }
        return this.jmxDispatcherConnection.getMbeanServerConnection();
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        try {
            this.getMbs().addNotificationListener(name, listener, filter, handback);
        }
        catch (IOException e) {
            log.info("Exception in addNotificationListener", e);
        }
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        try {
            this.getMbs().addNotificationListener(name, listener, filter, handback);
        }
        catch (IOException e) {
            log.info("Exception in addNotificationListener", e);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            return this.getMbs().createMBean(className, name);
        }
        catch (IOException e) {
            log.info("Exception in createMBean", e);
            throw new MBeanException(e);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        try {
            return this.getMbs().createMBean(className, name, loaderName);
        }
        catch (IOException e) {
            log.info("Exception in createMBean", e);
            throw new MBeanException(e);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            return this.getMbs().createMBean(className, name, params, signature);
        }
        catch (IOException e) {
            log.info("Exception in createMBean", e);
            throw new MBeanException(e);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        try {
            return this.getMbs().createMBean(className, name, loaderName, params, signature);
        }
        catch (IOException e) {
            log.info("Exception in createMBean", e);
            throw new MBeanException(e);
        }
    }

    @Override
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        log.debug("deserialize1", name);
        return this.mBeanServer.deserialize(name, data);
    }

    @Override
    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        log.debug("deserialize2", className);
        return this.mBeanServer.deserialize(className, data);
    }

    @Override
    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        log.debug("deserialize3", className);
        return this.mBeanServer.deserialize(className, loaderName, data);
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        try {
            return this.getMbs().getAttribute(name, attribute);
        }
        catch (IOException e) {
            log.info("Exception in getAttribute", e);
            throw new MBeanException(e);
        }
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        try {
            return this.getMbs().getAttributes(name, attributes);
        }
        catch (IOException e) {
            log.info("Exception in getAttributes", e);
            throw new PogoRuntimeException("Exception in getAttributes", e);
        }
    }

    @Override
    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        log.debug("getClassLoader", loaderName);
        return this.getClass().getClassLoader();
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        log.debug("getClassLoaderFor", mbeanName);
        return this.getClass().getClassLoader();
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        log.debug("getClassLoaderRepository");
        return this.mBeanServer.getClassLoaderRepository();
    }

    @Override
    public String getDefaultDomain() {
        try {
            return this.getMbs().getDefaultDomain();
        }
        catch (IOException e) {
            log.info("Exception in getDefaultDomain", e);
            throw new PogoRuntimeException("Exception in getDefaultDomain", e);
        }
    }

    @Override
    public String[] getDomains() {
        try {
            return this.getMbs().getDomains();
        }
        catch (IOException e) {
            log.info("Exception in getDomains", e);
            throw new PogoRuntimeException("Exception in getDomains", e);
        }
    }

    @Override
    public Integer getMBeanCount() {
        try {
            return this.getMbs().getMBeanCount();
        }
        catch (IOException e) {
            log.info("Exception in getMBeanCount", e);
            return 0;
        }
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        try {
            return this.getMbs().getMBeanInfo(name);
        }
        catch (IOException e) {
            log.info("Exception in getMBeanInfo", e);
            throw new PogoRuntimeException("Exception in getMBeanInfo", e);
        }
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        try {
            return this.getMbs().getObjectInstance(name);
        }
        catch (IOException e) {
            log.info("Exception in getObjectInstance", e);
            throw new PogoRuntimeException("Exception in getObjectInstance", e);
        }
    }

    @Override
    public Object instantiate(String className) throws ReflectionException, MBeanException {
        log.debug("instantiate1", className);
        return this.mBeanServer.instantiate(className);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        log.debug("instantiate2", className);
        return this.mBeanServer.instantiate(className, loaderName);
    }

    @Override
    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        log.debug("instantiate3", className);
        return this.mBeanServer.instantiate(className, params, signature);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        log.debug("instantiate4", className);
        return this.mBeanServer.instantiate(className, loaderName, params, signature);
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        try {
            return this.getMbs().invoke(name, operationName, params, signature);
        }
        catch (IOException e) {
            log.info("Exception in invoke", e);
            throw new MBeanException(e);
        }
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        try {
            return this.getMbs().isInstanceOf(name, className);
        }
        catch (IOException e) {
            log.info("Exception in isInstanceOf", e);
            return false;
        }
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        try {
            return this.getMbs().isRegistered(name);
        }
        catch (IOException e) {
            log.info("Exception in isRegistered", e);
            return false;
        }
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        try {
            return this.getMbs().queryMBeans(name, query);
        }
        catch (IOException e) {
            log.info("Exception in queryMBeans", e);
            return Collections.emptySet();
        }
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        try {
            return this.getMbs().queryNames(name, query);
        }
        catch (IOException e) {
            log.info("Exception in queryNames", e);
            return Collections.emptySet();
        }
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        log.debug("registerMBean", name);
        return this.mBeanServer.registerMBean(object, name);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.getMbs().removeNotificationListener(name, listener);
        }
        catch (IOException e) {
            log.info("Exception in removeNotificationListener", e);
            throw new PogoRuntimeException("Exception in removeNotificationListener", e);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.getMbs().removeNotificationListener(name, listener);
        }
        catch (IOException e) {
            log.info("Exception in removeNotificationListener", e);
            throw new PogoRuntimeException("Exception in removeNotificationListener", e);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.getMbs().removeNotificationListener(name, listener, filter, handback);
        }
        catch (IOException e) {
            log.info("Exception in removeNotificationListener", e);
            throw new PogoRuntimeException("Exception in removeNotificationListener", e);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.getMbs().removeNotificationListener(name, listener, filter, handback);
        }
        catch (IOException e) {
            log.info("Exception in removeNotificationListener", e);
            throw new PogoRuntimeException("Exception in removeNotificationListener", e);
        }
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            this.getMbs().setAttribute(name, attribute);
        }
        catch (IOException e) {
            log.info("Exception in setAttribute", e);
            throw new MBeanException(e);
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        try {
            return this.getMbs().setAttributes(name, attributes);
        }
        catch (IOException e) {
            log.info("Exception in setAttributes", e);
            throw new PogoRuntimeException("Exception in setAttributes", e);
        }
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        try {
            this.getMbs().unregisterMBean(name);
        }
        catch (IOException e) {
            log.info("Exception in unregisterMBean", e);
            throw new PogoRuntimeException("Exception in unregisterMBean", e);
        }
    }
}

