/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.remote.proxy;

import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.util.DomUtils;
import java.util.ArrayList;
import org.dom4j.Element;

public class ProxyConfiguration {
    public static final String ACTIVE_JMX_PROXY_URI_PARAMETER_NAME = "activeJMXProxyURI";
    public static final String JMX_PROXY_HOST_DISPATCHERS_PARAMETER_NAME = "jmxProxyHostDispatchers";
    public static final String DEFAULT_PROXY_SCAN_SERVICE = "presentationService";
    private static String proxyScanService;

    public static String getActiveJMXProxyURI(Configuration configuration) {
        if (configuration != null) {
            return configuration.getValue(ACTIVE_JMX_PROXY_URI_PARAMETER_NAME);
        }
        return "";
    }

    public static ArrayList<String> getJMXProxyHostDispatchers(Configuration configuration) {
        ArrayList<String> userPerferredProxyDispatchers = new ArrayList<String>();
        Element cmResponse = configuration.getCmResponse("configuration");
        if (cmResponse == null) {
            return userPerferredProxyDispatchers;
        }
        String sPath = "//queryResult/item[@xsi:type='cm:configuration']/jmxProxyHostDispatchers/value";
        Element elem = (Element)cmResponse.selectSingleNode(sPath);
        if (elem == null) {
            return userPerferredProxyDispatchers;
        }
        int idx = 0;
        for (Element item : DomUtils.selectElements(elem, "item")) {
            Element pathElem = (Element)item.selectSingleNode("searchPath/value");
            if (pathElem == null) continue;
            String searchPath = pathElem.getTextTrim();
            userPerferredProxyDispatchers.add(idx, searchPath);
            ++idx;
        }
        return userPerferredProxyDispatchers;
    }

    public static String getProxyScanService() {
        String pss = proxyScanService != null ? proxyScanService : System.getenv("JMX_PROXY_SCAN_SERVICE");
        return pss != null ? pss : DEFAULT_PROXY_SCAN_SERVICE;
    }

    public static void setProxyScanService(String proxyScanService) {
        ProxyConfiguration.proxyScanService = proxyScanService;
    }
}

