/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.remote.proxy.chooser;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.ProxyUpdater;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;

public class ChooserHandler
extends BasicHandler {
    private static final PogoLogger log = PogoLogger.getLogger();
    private Configuration configuration;
    private ProxyUpdater proxyUpdater;

    public ChooserHandler() {
        super(log.getNativeLogger());
    }

    @Override
    public void configure(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void reconfigure(Configuration configuration) {
        log.debug("reconfigure() - start reconfigure.");
        this.changeProxyUpdaterState(configuration);
    }

    @Override
    public void start() {
        this.changeProxyUpdaterState(this.configuration);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
    }

    ProxyUpdater getProxyUpdater() {
        return this.proxyUpdater;
    }

    private void changeProxyUpdaterState(Configuration configuration) {
        if (this.isLocalActiveCM(configuration)) {
            log.debug("changeProxyUpdaterState - This is the active CM box, start the proxy monitor/updater. ");
            this.getProxyMonitor(configuration);
            this.proxyUpdater.start(configuration);
        } else {
            log.debug("changeProxyUpdaterState - This is not active CM, stop the proxy monitor/updater if running. ");
            this.stopProxyUpdaterIfRunning();
        }
    }

    private void getProxyMonitor(Configuration configuration) {
        if (this.proxyUpdater == null) {
            this.proxyUpdater = new ProxyUpdater(configuration);
        }
    }

    private void stopProxyUpdaterIfRunning() {
        if (this.proxyUpdater != null) {
            this.proxyUpdater.stop();
            log.debug("Stopping proxy updater");
            this.proxyUpdater = null;
        }
    }

    private boolean isLocalActiveCM(Configuration configuration) {
        if (Boolean.getBoolean("com.ibm.cognos.pogo.noCM")) {
            return true;
        }
        String value = configuration.getValue("contentManager");
        NodeID nodeID = NodeID.getNodeID(value);
        return nodeID.isLocalToSelf();
    }

    void setProxyUpdaterForTest(ProxyUpdater proxyUpdater) {
        this.proxyUpdater = proxyUpdater;
    }
}

