/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.remote.proxy.chooser;

import com.cognos.pogo.monitoring.jmx.JMXDispatcherConnection;
import com.cognos.pogo.monitoring.jmx.JMXDispatcherConnectionFactory;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServerFactory;
import com.cognos.pogo.monitoring.jmx.ProxyServerCreator;
import com.cognos.pogo.monitoring.jmx.ProxyType;
import com.cognos.pogo.monitoring.jmx.remote.proxy.PogoMBeanServerForwarder;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.timer.PogoTimer;
import com.cognos.pogo.util.timer.PogoTimerOwner;
import javax.management.MBeanServerConnection;

public class ForwardingProxy
extends ProxyServerCreator
implements PogoTimerOwner {
    static final PogoLogger log = PogoLogger.getLogger();
    private static final int ACTIVE_PROXY_PING_INTERVAL = 10000;
    private final JMXDispatcherConnectionFactory jmxDispatcherConnectionFactory;
    private final PogoMBeanServerFactory pogoMBeanServerFactory;
    private String proxyJmxUrl;
    private PogoTimer searchActiveProxyTimer;
    private JMXDispatcherConnection jmxDispatcherConnection;
    private PogoMBeanServerForwarder forwarder;

    public ForwardingProxy(ProxyServerCreator oldProxyServerCreator) {
        this(oldProxyServerCreator, new JMXDispatcherConnectionFactory(), new PogoMBeanServerFactory());
    }

    public ForwardingProxy(ProxyServerCreator oldProxyServerCreator, JMXDispatcherConnectionFactory jmxDispatcherConnectionFactory, PogoMBeanServerFactory pogoMBeanServerFactory) {
        super(oldProxyServerCreator);
        this.jmxDispatcherConnectionFactory = jmxDispatcherConnectionFactory;
        this.pogoMBeanServerFactory = pogoMBeanServerFactory;
    }

    @Override
    public void start() {
        log.debug("start() - Get forwarding proxy svr connection to '", this.proxyJmxUrl, "'");
        this.jmxDispatcherConnection = this.jmxDispatcherConnectionFactory.createConnection(this.proxyJmxUrl);
        MBeanServerConnection proxySvrConnection = this.jmxDispatcherConnection.getMbeanServerConnection();
        if (proxySvrConnection != null) {
            this.startForwardingProxyServer(this.jmxDispatcherConnection);
        } else {
            this.searchForActiveProxy();
        }
    }

    private void startForwardingProxyServer(JMXDispatcherConnection jmxDispatcherConnection2) {
        log.debug("startForwardingProxyServer: Remote proxy server connection found = ", jmxDispatcherConnection2);
        PogoMBeanServerForwarder forwarder = this.createForwarder(jmxDispatcherConnection2);
        this.createPogoMBeanServer(forwarder);
    }

    private PogoMBeanServerForwarder createForwarder(JMXDispatcherConnection jmxDispatcherConnection2) {
        this.forwarder = new PogoMBeanServerForwarder();
        this.forwarder.setJmxDispatcherConnection(jmxDispatcherConnection2);
        return this.forwarder;
    }

    private void createPogoMBeanServer(PogoMBeanServerForwarder forwarder) {
        PogoMBeanServer pogoMBeanServer = this.pogoMBeanServerFactory.getPogoMBeanServer();
        pogoMBeanServer.setProxyMBeanServer(forwarder);
        pogoMBeanServer.startProxyRMIConnector();
        pogoMBeanServer.startProxyJMXMPConnector();
    }

    private boolean activeProxyConnectionIsAvailable() {
        log.debug("activeProxyConnectionIsAvailable");
        MBeanServerConnection proxySvrConnection = this.jmxDispatcherConnection.getMbeanServerConnection();
        if (proxySvrConnection != null) {
            this.startForwardingProxyServer(this.jmxDispatcherConnection);
            return true;
        }
        return false;
    }

    private void searchForActiveProxy() {
        log.debug("searchForActiveProxy() - start timer to search active proxy server '", this.proxyJmxUrl, "'");
        this.searchActiveProxyTimer = new PogoTimer(this, null, 10000L, 10000L);
    }

    @Override
    public void handleTimeoutEvent(Object parameter) throws Exception {
        log.debug("handleTimeoutEvent");
        this.connectToProxyServer();
    }

    private synchronized void connectToProxyServer() {
        log.debug("connectToProxyServer");
        if (this.isSearchingForActiveProxy() && this.activeProxyConnectionIsAvailable()) {
            this.stopTimer();
        }
    }

    private void stopTimer() {
        log.debug("stopTimer");
        if (this.searchActiveProxyTimer != null) {
            this.searchActiveProxyTimer.cancel();
            this.searchActiveProxyTimer = null;
        }
    }

    @Override
    public void setUrl(String activeProxyName) {
        this.proxyJmxUrl = activeProxyName;
    }

    @Override
    public void deactivate() {
        log.debug("Deactivating forwarding proxy server. Proxy jmx url: '", this.proxyJmxUrl);
        try {
            this.stopTimer();
            this.jmxDispatcherConnection.disconnect();
            this.disconnectMBeanServer();
        }
        catch (Exception e) {
            log.warn("Deactivating forwarding proxy failed: ", e);
        }
    }

    private void disconnectMBeanServer() {
        PogoMBeanServer pogoMBeanServer = this.pogoMBeanServerFactory.getPogoMBeanServer();
        pogoMBeanServer.stopProxyRMIConnector();
        pogoMBeanServer.stopProxyJMXMPConnector();
    }

    @Override
    public ProxyType getType() {
        return ProxyType.FORWARDING;
    }

    @Override
    public void updateReceived() {
        log.debug("updateReceived");
        this.resetProxyServerConnection();
        this.connectToProxyServer();
    }

    private void resetProxyServerConnection() {
        if (!this.jmxDispatcherConnection.canConnect()) {
            this.jmxDispatcherConnection.disconnect();
            this.jmxDispatcherConnection.connect();
        }
    }

    boolean isSearchingForActiveProxy() {
        return this.searchActiveProxyTimer != null;
    }
}

