/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.remote.proxy.chooser;

import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.ChooseProxy;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.PingFailureCallback;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.ProxyObserver;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.ProxyPinger;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.ProxyPingerFactory;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.ProxyPingerFactoryImpl;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.util.PogoLogger;
import java.util.ArrayList;

public class ProxyMonitor
implements PingFailureCallback {
    private static PogoLogger log = PogoLogger.getLogger();
    private ChooseProxy chooseProxy;
    private final ProxyPingerFactory proxyPingerFactory;
    private ArrayList<ProxyObserver> proxyObservers = new ArrayList();
    private String currentActiveProxy;
    private ProxyPinger proxyPinger;

    public ProxyMonitor() {
        this(new ProxyPingerFactoryImpl());
    }

    public ProxyMonitor(ProxyPingerFactory proxyPingerFactory) {
        this(proxyPingerFactory, null);
    }

    public ProxyMonitor(ProxyPingerFactory proxyPingerFactory, String currentActiveProxy2) {
        this.proxyPingerFactory = proxyPingerFactory;
        this.currentActiveProxy = currentActiveProxy2;
    }

    public void addObserver(ProxyObserver proxyObserver) {
        this.proxyObservers.add(proxyObserver);
    }

    public void start(Configuration configuration) {
        this.start(new ChooseProxy(configuration));
    }

    void start(ChooseProxy newChooseProxy) {
        if (this.chooseProxyHasChanged(newChooseProxy)) {
            log.debug("start(ChooseProxy newChooseProxy) - the ChooseProxy object has been changed.");
            this.chooseProxy = newChooseProxy;
            this.checkAndMonitor();
        }
    }

    private boolean chooseProxyHasChanged(ChooseProxy newChooseProxy) {
        return this.chooseProxy == null || !this.chooseProxy.equals(newChooseProxy);
    }

    private void checkAndMonitor() {
        this.chooseProxy.scanForProxy();
        String newActiveProxy = this.chooseProxy.getNewActiveProxy();
        if (this.proxyHasChanged(newActiveProxy)) {
            log.debug("checkAndMonitor() - Proxy server has changed from '" + this.currentActiveProxy + "' to '" + newActiveProxy + "'");
            this.currentActiveProxy = newActiveProxy;
            this.notifyObservers(this.currentActiveProxy);
            this.stop();
            this.proxyPinger = this.createProxyPinger();
            this.proxyPinger.monitor(this);
        }
    }

    private boolean proxyHasChanged(String newActiveProxy) {
        return newActiveProxy != null && (this.currentActiveProxy == null || !this.currentActiveProxy.equals(newActiveProxy));
    }

    private ProxyPinger createProxyPinger() {
        return this.proxyPingerFactory.createProxyPinger(this.currentActiveProxy);
    }

    private void notifyObservers(String newActiveProxy) {
        for (ProxyObserver proxyObserver : this.proxyObservers) {
            proxyObserver.update(newActiveProxy);
        }
    }

    private void ignoreAndRecheck() {
        log.debug("ignoreAndRecheck() - the proxy '" + this.currentActiveProxy + "' is not avaliable, remove it from the candidate list and check for the next avaliable one.");
        this.chooseProxy.ignoreProxy(this.currentActiveProxy);
        this.checkAndMonitor();
    }

    ChooseProxy getChooseProxy() {
        return this.chooseProxy;
    }

    @Override
    public void pingFaliure() {
        this.ignoreAndRecheck();
    }

    public void stop() {
        log.debug("stop() - Stop the proxy monitor, cancel the proxyPinger timer.");
        if (this.proxyPinger != null) {
            this.proxyPinger.stop();
        }
    }
}

