/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.remote.proxy.chooser;

import com.cognos.pogo.http.SimpleHttpConnection;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.PingFailureCallback;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.ProxyPinger;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.threads.SafeTimerTask;
import java.util.Timer;
import java.util.TimerTask;

public class ProxyPingerImpl
extends ProxyPinger {
    private static PogoLogger log = PogoLogger.getLogger();
    private static final String CHECKPROXY_EXTENSION = "/servlet/dispatch/checkproxy";
    private static final int PROXY_PING_INTERVAL = 10000;
    protected String proxyPingUrl;
    private SimpleHttpConnection connection;
    private Timer timer;

    public ProxyPingerImpl(String jmxurl) {
        this(jmxurl, new Timer(true));
        this.connection = this.createSimpleHttpConnection();
    }

    public ProxyPingerImpl(String jmxurl, Timer timer) {
        super(jmxurl);
        this.proxyPingUrl = MBeanUtils.getHostUrlFromHessianUrl(jmxurl) + CHECKPROXY_EXTENSION;
        this.timer = timer;
    }

    public void setHttpConnection(SimpleHttpConnection simpleHttpConnection) {
        this.connection = simpleHttpConnection;
    }

    protected SimpleHttpConnection createSimpleHttpConnection() {
        try {
            return this.getNewSimpleHttpConnection();
        }
        catch (Exception e) {
            log.error("ProxyPingerImpl() - Unable to create connection to '" + this.proxyPingUrl + "'. Ping to the proxy server will fail. ", e);
            return null;
        }
    }

    protected SimpleHttpConnection getNewSimpleHttpConnection() throws Exception {
        return SimpleHttpConnection.getNewConnection(this.proxyPingUrl);
    }

    @Override
    public void monitor(PingFailureCallback callback) {
        this.monitor(callback, 10000);
    }

    protected void monitor(final PingFailureCallback callback, int pingInterval) {
        log.debug("monitor() - start timer to monitor proxy server '" + this.proxyPingUrl + "'");
        this.timer.schedule((TimerTask)new SafeTimerTask("JMXProxyPinger"){

            @Override
            public void safeRun() {
                if (!ProxyPingerImpl.this.proxyIsAvailable()) {
                    ProxyPingerImpl.this.cancelTimer(callback);
                }
            }
        }, pingInterval, (long)pingInterval);
    }

    protected void cancelTimer(PingFailureCallback callback) {
        log.debug("cancelTimer() - The proxy server '" + this.proxyPingUrl + "' is not available any more, cancel the timer.");
        this.timer.cancel();
        this.notifyFailure(callback);
    }

    @Override
    public boolean proxyIsAvailable() {
        String response = null;
        if (this.connection != null) {
            response = this.connection.get();
        }
        return response != null;
    }

    @Override
    public void notifyFailure(PingFailureCallback callback) {
        callback.pingFaliure();
    }

    @Override
    public void stop() {
        log.debug("stop() - stop pingging if the proxy server is avaliable or not.");
        if (this.timer != null) {
            this.timer.cancel();
        }
    }
}

