/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.remote.proxy.chooser;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.monitoring.jmx.ProxyServerCreator;
import com.cognos.pogo.monitoring.jmx.remote.proxy.ProxyConfiguration;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.CheckProxyResponse;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.EmptyProxyServerCreator;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.EventSubscriber;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.ProxyServerCreatorFactory;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class ProxyServerControl {
    private static final PogoLogger log = PogoLogger.getLogger();
    private final ProxyServerCreatorFactory factory;
    protected final List<EventSubscriber> eventSubscribers = new ArrayList<EventSubscriber>();
    private ProxyServerCreator creator = new EmptyProxyServerCreator();
    private Configuration configurationForStart;
    private String currentProxyJmxUrl = "";

    public ProxyServerControl(ProxyServerCreatorFactory proxyServerCreatorFactory) {
        this.factory = proxyServerCreatorFactory;
    }

    public String getStatus() {
        return this.creator.getType().toString();
    }

    public byte[] getProxyResponse() {
        CheckProxyResponse checkProxyResponse = new CheckProxyResponse(this.getStatus(), this.currentProxyJmxUrl);
        return checkProxyResponse.getResponse();
    }

    public void configure(Configuration configuration) {
        this.creator.configure(configuration);
        this.configurationForStart = configuration;
    }

    public void reconfigure(Configuration configuration) {
        this.creator.reconfigure(configuration);
        this.setupProxyFromConfiguration(configuration);
    }

    public void start() {
        this.setupProxyFromConfiguration(this.configurationForStart);
    }

    private void setupProxyFromConfiguration(Configuration configuration) {
        String proxyJmxUrl = ProxyConfiguration.getActiveJMXProxyURI(configuration);
        if (this.hasProxyUrlChanged(proxyJmxUrl)) {
            this.setupProxy(proxyJmxUrl);
        }
    }

    private boolean hasProxyUrlChanged(String proxyJmxUrl) {
        return StringUtils.isNotEmpty((String)proxyJmxUrl) && !proxyJmxUrl.equals(this.currentProxyJmxUrl);
    }

    private void setupProxy(String proxyJmxUrl) {
        this.setCurrentProxyJmxURL(proxyJmxUrl);
        if (this.isLocalProxy()) {
            this.activateProxy();
        } else {
            this.useForwardingProxy();
        }
    }

    private void setCurrentProxyJmxURL(String proxyJmxUrl) {
        log.debug("The proxy jmx url has been changed from '", this.currentProxyJmxUrl, "' to '", proxyJmxUrl, "'.");
        this.currentProxyJmxUrl = proxyJmxUrl;
    }

    private boolean isLocalProxy() {
        String host = MBeanUtils.getHostFromUrl(this.currentProxyJmxUrl);
        NodeID nodeID = NodeID.getNodeID(host);
        return nodeID.isLocalToSelf();
    }

    private void activateProxy() {
        log.info("Activating local proxy server");
        this.stopCurrentProxyServer();
        this.createActiveProxy();
    }

    private void stopCurrentProxyServer() {
        this.creator.deactivate();
        for (EventSubscriber subscriber : this.eventSubscribers) {
            subscriber.proxyServerStopped(this.creator);
        }
    }

    private void createActiveProxy() {
        this.creator = this.factory.createActiveProxy(this.creator);
        this.startProxyServer();
    }

    private void useForwardingProxy() {
        log.info("Use forwarding proxy: ", this.currentProxyJmxUrl);
        this.stopCurrentProxyServer();
        this.createForwardingProxy();
    }

    private void createForwardingProxy() {
        this.creator = this.factory.createForwardingProxy(this.creator);
        this.creator.setUrl(this.currentProxyJmxUrl);
        this.startProxyServer();
    }

    private void startProxyServer() {
        this.creator.start();
        for (EventSubscriber subscriber : this.eventSubscribers) {
            subscriber.proxyServerStarted(this.creator);
        }
    }

    public void registerForNotifications(EventSubscriber subscriber) {
        this.eventSubscribers.add(subscriber);
    }

    public void contextualize(Element configElement) throws PogoException {
        this.creator.contextualize(configElement);
    }

    public void updateReceived() {
        this.creator.updateReceived();
    }
}

