/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.report;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.bibus.BIBusCommand;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.monitoring.Tenancy;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.transport.DispatcherConnectionManager;
import com.cognos.pogo.transport.FormRequestProcessor;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;

public class CAMIdentityQuery
extends BIBusCommand {
    private static final String CAM_INTERNAL_SOAP_ACTION = "http://www.ibm.com/xmlns/prod/cognos/sacamsrvc-internal" + FormRequestProcessor.C10_SERVICE_VERSION_SUFFIX;
    private Tenancy tenancy;
    private int connectionTimeout = -1;
    private String passportID;

    public CAMIdentityQuery(String passportID) {
        this.passportID = passportID;
        this.setDoTrustedRequest(true);
    }

    public Tenancy getTenancy() {
        return this.tenancy;
    }

    @Override
    protected void executeImpl(Element bodyElement) throws CommandExecutionException {
        BIBusEnvelope requestEnvelope = this.getRequestEnvelope();
        requestEnvelope.createCamPassportElement(this.passportID);
        Namespace ns = new Namespace("cam", "http://developer.cognos.com/schemas/saCAMService/1");
        QName qName = new QName("getIdentity", ns);
        Element e = DocumentHelper.createElement((QName)qName);
        bodyElement.add(e);
    }

    @Override
    protected void handleResponseImpl(Element bodyElement) throws CommandExecutionException {
        boolean isImpersonating = Boolean.parseBoolean(bodyElement.selectSingleNode("//*[local-name()='isImpersonating']").getText());
        List readTenantIdNodes = bodyElement.selectNodes("//*[local-name()='readTenantIDs']//*[local-name()='item']");
        ArrayList<String> readTenantIds = new ArrayList<String>(readTenantIdNodes.size());
        if (readTenantIdNodes != null) {
            for (Node tenantIdNode : readTenantIdNodes) {
                readTenantIds.add(tenantIdNode.getText());
            }
        }
        String writeTenantId = null;
        Node writeTenantIdNode = bodyElement.selectSingleNode("//*[local-name()='writeTenantID']//*[local-name()='item']");
        if (writeTenantIdNode != null) {
            writeTenantId = writeTenantIdNode.getText();
        }
        this.tenancy = new Tenancy(isImpersonating, readTenantIds, writeTenantId);
    }

    @Override
    protected ServerConnection fetchServerConnection() {
        ServerConnection contentManagerConnection = DispatcherConnectionManager.getContentManagerConnection();
        if (this.connectionTimeout != -1) {
            contentManagerConnection.setConnectionTimeout(this.connectionTimeout);
        }
        return contentManagerConnection;
    }

    @Override
    protected String fetchRequestContext() {
        return NodeID.getSelf().getPath();
    }

    @Override
    protected void addExtraHTTPHeaders(ServerConnection connection) {
        super.addExtraHTTPHeaders(connection);
        connection.setRequestHeader("SOAPAction", CAM_INTERNAL_SOAP_ACTION);
    }
}

