/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.report;

import com.cognos.pogo.monitoring.jmx.report.ProxyInteractiveReportMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.DynamicMBean;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class InteractiveReportAggregator
extends ProxyInteractiveReportMonitor {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(InteractiveReportAggregator.class.getName());

    @Override
    protected String[] getTypes(Object[] arguments) {
        if (arguments.length == 8) {
            String[] types = (String[])arguments[2];
            return types;
        }
        String[] requestIDs = (String[])arguments[0];
        String[] types = new String[requestIDs.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = "ReportService";
        }
        return types;
    }

    public void addMBean(String service, DynamicMBean typeMBean) {
        this.typeMBeans.put(service, typeMBean);
    }

    @Override
    protected HashMap<Object, Object[]> proxyInvoke(String method, Object[] arguments, String[] params) throws ReflectionException {
        HashMap<Object, Object[]> returnMap = new HashMap<Object, Object[]>();
        for (Map.Entry entry : this.typeMBeans.entrySet()) {
            Object serviceName = entry.getKey();
            DynamicMBean mbean = (DynamicMBean)entry.getValue();
            try {
                Object[] reportDetails = (Object[])mbean.invoke(method, arguments, params);
                returnMap.put(serviceName, reportDetails);
            }
            catch (MBeanException e) {
                cat.info("MBeanException in proxyInvoke", (Throwable)e);
            }
        }
        return returnMap;
    }

    @Override
    protected ArrayList<CompositeData> mergeResults(String[] reportIDs, String[] types, HashMap<Object, Object[]> typeResults) {
        return this.merge(reportIDs, typeResults.values());
    }

    public ArrayList<CompositeData> merge(String[] reportIDs, Collection<?> collection) {
        HashMap<String, CompositeData> resultHash = this.createResultHash(collection);
        ArrayList<CompositeData> merged = new ArrayList<CompositeData>();
        for (int i = 0; i < reportIDs.length; ++i) {
            CompositeData composite = resultHash.get(reportIDs[i]);
            if (composite == null) continue;
            merged.add(composite);
        }
        return merged;
    }

    private HashMap<String, CompositeData> createResultHash(Collection<?> collection) {
        HashMap<String, CompositeData> resultHash = new HashMap<String, CompositeData>();
        for (CompositeData[] composites : collection) {
            for (int i = 1; i < composites.length; ++i) {
                String key = (String)composites[i].get("RequestID");
                resultHash.put(key, composites[i]);
            }
        }
        return resultHash;
    }
}

