/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.report;

import com.cognos.pogo.monitoring.jmx.MBeanRepository;
import com.cognos.pogo.monitoring.jmx.proxy.UpdateGroupsInterface;
import com.cognos.pogo.monitoring.jmx.report.CountCompositeDataSupport;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import mx4j.tools.remote.proxy.RemoteMBeanProxyException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ProxyInteractiveReportMonitor
implements DynamicMBean,
UpdateGroupsInterface {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ProxyInteractiveReportMonitor.class.getName());
    private static final String description = "ProxyInteractiveReportMonitor";
    protected HashMap<String, DynamicMBean> typeMBeans = new HashMap();
    private MBeanInfo mbeanInfo;

    public ProxyInteractiveReportMonitor() {
    }

    public ProxyInteractiveReportMonitor(MBeanRepository proxyMBeanList) {
        this.getProxiedMBeans(proxyMBeanList);
    }

    private void getProxiedMBeans(MBeanRepository proxyMBeanList) {
        try {
            MBeanRepository beanMap = proxyMBeanList.getPattern(MBeanUtils.createObjectNameInstance("type=ReportServerInteractiveRequests,*"));
            for (ObjectName name : beanMap.getObjectNames()) {
                String dispatcherName = name.getKeyProperty("dispatcher");
                if (dispatcherName == null) continue;
                this.typeMBeans.put(ObjectName.unquote(dispatcherName), proxyMBeanList.get(name));
            }
        }
        catch (MalformedObjectNameException e) {
            cat.info("MalformedObjectNameException", (Throwable)e);
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute.equals("Reports")) {
            return this.getReports();
        }
        return null;
    }

    @Override
    public Object invoke(String method, Object[] arguments, String[] params) throws MBeanException, ReflectionException {
        if (method.equals("getReports")) {
            return this.getReports();
        }
        if (method.equals("getDetails")) {
            return this.getDetails(arguments, params);
        }
        if (method.equals("cancelReports")) {
            return this.cancelReports(arguments, params);
        }
        throw new ReflectionException(new NoSuchMethodException(method), "Cannot find the operation " + method + " in ProxyInteractiveReportMonitor");
    }

    private Object getReports() {
        ArrayList<CompositeData> returnList = new ArrayList<CompositeData>();
        for (DynamicMBean mbean : this.typeMBeans.values()) {
            try {
                CompositeData[] dispatcherReports = (CompositeData[])mbean.getAttribute("Reports");
                returnList.addAll(Arrays.asList(dispatcherReports));
            }
            catch (JMException e) {
                cat.info("JMX exception", (Throwable)e);
            }
            catch (RemoteMBeanProxyException e) {
                cat.info("JMX RemoteMBeanProxyException", (Throwable)e);
            }
        }
        return returnList.toArray(new CompositeData[returnList.size()]);
    }

    private Object getDetails(Object[] arguments, String[] params) throws ReflectionException {
        HashMap<Object, Object[]> invokeList = this.proxyInvoke("getDetails", arguments, params);
        try {
            List<CompositeData> returnList = this.integrate(arguments, invokeList);
            return returnList.toArray(new CompositeData[returnList.size()]);
        }
        catch (JMException e) {
            cat.info("caught exception in getDetails", (Throwable)e);
            throw new ReflectionException(e);
        }
    }

    private List<CompositeData> integrate(Object[] arguments, HashMap<Object, Object[]> invokeList) throws OpenDataException {
        String[] reportIDs = (String[])arguments[0];
        String[] types = this.getTypes(arguments);
        int offset = 0;
        int pagesize = reportIDs.length;
        if (arguments.length > 5) {
            offset = this.getOffset(arguments);
            pagesize = this.getPagesize(arguments);
        }
        CompositeData count = this.extractCounts(invokeList);
        ArrayList<CompositeData> returnList = this.mergeResults(reportIDs, types, invokeList);
        int limit = Math.min(returnList.size(), offset + pagesize);
        List<CompositeData> currentPageList = offset > limit ? returnList.subList(limit, limit) : returnList.subList(offset, limit);
        currentPageList.add(0, count);
        return currentPageList;
    }

    protected ArrayList<CompositeData> mergeResults(String[] reportIDs, String[] types, HashMap<Object, Object[]> invokeList) {
        List<CompositeData> dispList;
        HashMap<String, List<CompositeData>> typeArrayHash = this.convertToArrayLists(invokeList);
        ArrayList<CompositeData> returnList = new ArrayList<CompositeData>();
        for (int i = 0; i < reportIDs.length && (dispList = typeArrayHash.get(types[i])).size() != 0; ++i) {
            CompositeData details = dispList.get(0);
            if (!reportIDs[i].equals(details.get("RequestID"))) continue;
            dispList.remove(0);
            returnList.add(details);
        }
        return returnList;
    }

    private HashMap<String, List<CompositeData>> convertToArrayLists(HashMap<Object, Object[]> typeResults) {
        HashMap<String, List<CompositeData>> dispatcherComposites = new HashMap<String, List<CompositeData>>();
        for (Map.Entry<Object, Object[]> entry : typeResults.entrySet()) {
            String dispatcher = (String)entry.getKey();
            CompositeData[] composites = (CompositeData[])entry.getValue();
            ArrayList<CompositeData> detailList = new ArrayList<CompositeData>(Arrays.asList(composites));
            dispatcherComposites.put(dispatcher, detailList.subList(1, detailList.size()));
        }
        return dispatcherComposites;
    }

    private int getPagesize(Object[] arguments) {
        return (Integer)arguments[4];
    }

    private int getOffset(Object[] arguments) {
        return (Integer)arguments[3];
    }

    protected String[] getTypes(Object[] arguments) {
        String[] types = (String[])arguments[1];
        return types;
    }

    private CompositeData extractCounts(HashMap<Object, Object[]> invokeList) throws OpenDataException {
        long total = 0L;
        long running = 0L;
        long pending = 0L;
        for (CompositeData[] compositeDataArray : invokeList.values()) {
            CompositeData counts = compositeDataArray[0];
            total += ((Long)counts.get("total")).longValue();
            running += ((Long)counts.get("running")).longValue();
            pending += ((Long)counts.get("pending")).longValue();
        }
        CountCompositeDataSupport countCompositeDataSupport = new CountCompositeDataSupport();
        CompositeDataSupport compositeDataSupport = countCompositeDataSupport.getCountCompositeData(running, pending, total);
        return compositeDataSupport;
    }

    String[] cancelReports(Object[] arguments, String[] params) throws ReflectionException {
        HashMap<Object, Object[]> invokeList = this.proxyInvoke("cancelReports", arguments, params);
        ArrayList<String> returnList = new ArrayList<String>();
        Iterator<Object[]> iter = invokeList.values().iterator();
        while (iter.hasNext()) {
            String[] a;
            for (String result : a = (String[])iter.next()) {
                if (result == null) continue;
                returnList.add(result);
            }
        }
        return returnList.toArray(new String[returnList.size()]);
    }

    protected HashMap<Object, Object[]> proxyInvoke(String method, Object[] arguments, String[] params) throws ReflectionException {
        HashMap<Object, Object[]> returnList = new HashMap<Object, Object[]>();
        String[] reportIDs = (String[])arguments[0];
        String[] dispatchers = this.getTypes(arguments);
        if (reportIDs.length != dispatchers.length) {
            throw new ReflectionException(new InvalidAttributeValueException());
        }
        HashMap<String, ArrayList<String>> idMap = this.getIdMap(reportIDs, dispatchers);
        for (Map.Entry<String, ArrayList<String>> entry : idMap.entrySet()) {
            String dispatcherName = entry.getKey();
            ArrayList<String> idList = entry.getValue();
            DynamicMBean mbean = this.typeMBeans.get(dispatcherName);
            String[] idArray = idList.toArray(new String[idList.size()]);
            Object[] args = this.copyArguments(arguments, idArray);
            try {
                Object[] reportDetails = (Object[])mbean.invoke(method, args, params);
                returnList.put(dispatcherName, reportDetails);
            }
            catch (MBeanException e) {
                cat.info("MBeanException in proxyInvoke", (Throwable)e);
            }
        }
        return returnList;
    }

    private Object[] copyArguments(Object[] arguments, String[] idArray) {
        Object[] args = new Object[arguments.length];
        args[0] = idArray;
        args[1] = null;
        for (int i = 2; i < arguments.length; ++i) {
            args[i] = arguments[i];
        }
        return args;
    }

    private HashMap<String, ArrayList<String>> getIdMap(String[] reportIDs, String[] dispatchers) {
        HashMap<String, ArrayList<String>> idMap = new HashMap<String, ArrayList<String>>();
        for (int i = 0; i < dispatchers.length; ++i) {
            ArrayList<String> dispIds = idMap.get(dispatchers[i]);
            if (dispIds == null) {
                dispIds = new ArrayList();
                idMap.put(dispatchers[i], dispIds);
            }
            dispIds.add(reportIDs[i]);
        }
        return idMap;
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            try {
                list.add(new Attribute(attributes[i], this.getAttribute(attributes[i])));
                continue;
            }
            catch (JMException e) {
                cat.info("Exception getting attribute " + attributes[i], (Throwable)e);
            }
        }
        return list;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    protected MBeanAttributeInfo[] createMBeanAttributeInfo() {
        return new MBeanAttributeInfo[]{new MBeanAttributeInfo("Reports", CompositeData[].class.getName(), "Reports", true, false, false)};
    }

    protected MBeanOperationInfo[] createMBeanOperationInfo() {
        MBeanParameterInfo[] getDetailsSignature = new MBeanParameterInfo[]{new MBeanParameterInfo("reportIDs", String[].class.getName(), "reportIDs"), new MBeanParameterInfo("dispatchers", String[].class.getName(), "dispatchers"), new MBeanParameterInfo("contentLocale", String.class.getName(), "contentLocale"), new MBeanParameterInfo("pageOffset", "int", "pageOffset"), new MBeanParameterInfo("pageSize", "int", "pageSize"), new MBeanParameterInfo("passportID", String.class.getName(), "passportID"), new MBeanParameterInfo("shown", "boolean", "shown")};
        MBeanParameterInfo[] getDetailsSignature2 = new MBeanParameterInfo[]{new MBeanParameterInfo("reportIDs", String[].class.getName(), "reportIDs"), new MBeanParameterInfo("dispatchers", String[].class.getName(), "dispatchers"), new MBeanParameterInfo("services", String[].class.getName(), "services"), new MBeanParameterInfo("contentLocale", String.class.getName(), "contentLocale"), new MBeanParameterInfo("pageOffset", "int", "pageOffset"), new MBeanParameterInfo("pageSize", "int", "pageSize"), new MBeanParameterInfo("passportID", String.class.getName(), "passportID"), new MBeanParameterInfo("shown", "boolean", "shown")};
        MBeanParameterInfo[] cancelReportsSignature = new MBeanParameterInfo[]{new MBeanParameterInfo("reportIDs", String[].class.getName(), "reportIDs"), new MBeanParameterInfo("dispatchers", String[].class.getName(), "dispatchers"), new MBeanParameterInfo("passportID", String.class.getName(), "passportID"), new MBeanParameterInfo("contentLocale", String.class.getName(), "contentLocale")};
        MBeanParameterInfo[] cancelReportsSignature2 = new MBeanParameterInfo[]{new MBeanParameterInfo("reportIDs", String[].class.getName(), "reportIDs"), new MBeanParameterInfo("dispatchers", String[].class.getName(), "dispatchers"), new MBeanParameterInfo("services", String[].class.getName(), "services"), new MBeanParameterInfo("passportID", String.class.getName(), "passportID"), new MBeanParameterInfo("contentLocale", String.class.getName(), "contentLocale")};
        return new MBeanOperationInfo[]{new MBeanOperationInfo("getDetails", "getDetails", getDetailsSignature, null, 0), new MBeanOperationInfo("getDetails", "getDetails", getDetailsSignature2, null, 0), new MBeanOperationInfo("cancelReports", "cancelReports", cancelReportsSignature, null, 0), new MBeanOperationInfo("cancelReports", "cancelReports", cancelReportsSignature2, null, 0)};
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.mbeanInfo == null) {
            this.mbeanInfo = this.createMbeanInfo();
        }
        return this.mbeanInfo;
    }

    private MBeanInfo createMbeanInfo() {
        MBeanAttributeInfo[] attributeInfo = this.createMBeanAttributeInfo();
        MBeanOperationInfo[] operationInfo = this.createMBeanOperationInfo();
        String className = ProxyInteractiveReportMonitor.class.getName();
        return new MBeanInfo(className, description, attributeInfo, null, operationInfo, null);
    }

    @Override
    public void updateGroups(MBeanRepository repository) {
        this.typeMBeans.clear();
        this.getProxiedMBeans(repository);
    }
}

