/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.threshold;

import com.cognos.pogo.monitoring.jmx.MBeanRepository;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.proxy.NotifyingDynamicMBean;
import com.cognos.pogo.monitoring.jmx.threshold.DispatcherMBeanHealth;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdManager;
import com.cognos.pogo.monitoring.jmx.utils.MBeanRepositoryFilter;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import java.util.Iterator;
import java.util.Map;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ConsolidatedHealthMBeanCollection {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ConsolidatedHealthMBeanCollection.class.getName());
    private MBeanServer proxyMbeanServer;
    private ThresholdManager thresholdManager;
    private MBeanServer localServer;
    private final MBeanRepository mBeanRepository;

    public ConsolidatedHealthMBeanCollection(MBeanRepository beanRepository, ThresholdManager thresholdManager) {
        this.mBeanRepository = beanRepository;
        this.thresholdManager = thresholdManager;
        this.proxyMbeanServer = PogoMBeanServer.getInstance().getProxyMBeanServer();
        this.localServer = PogoMBeanServer.getInstance().getServer();
    }

    public DispatcherMBeanHealth createHealthMBean(ObjectName name, NotifyingDynamicMBean metricMbean) {
        try {
            ObjectName healthObjectName = this.createHealthObjectName(name);
            DispatcherMBeanHealth healthMBean = new DispatcherMBeanHealth(metricMbean.getMBeanInfo(), name.toString(), metricMbean);
            healthMBean.setLocalSearchPath("/configuration");
            this.thresholdManager.addThresholdReceiver(name, healthMBean, metricMbean);
            this.proxyMbeanServer.addNotificationListener(name, healthMBean, null, null);
            this.registerInServers(healthMBean, healthObjectName);
            return healthMBean;
        }
        catch (InstanceAlreadyExistsException e) {
            cat.debug("Exception creating proxy health MBean for " + name.toString(), (Throwable)e);
        }
        catch (Exception e) {
            cat.error("Exception creating proxy health MBean for " + name.toString(), (Throwable)e);
        }
        return null;
    }

    private void registerInServers(DispatcherMBeanHealth healthMBean, ObjectName healthObjectName) throws JMException {
        if (this.localServer.isRegistered(healthObjectName)) {
            this.localServer.unregisterMBean(healthObjectName);
        }
        this.localServer.registerMBean(healthMBean, healthObjectName);
        if (this.mBeanRepository.isRegistered(healthObjectName)) {
            this.mBeanRepository.unregisterMBean(healthObjectName);
        }
        this.mBeanRepository.registerMBean(healthObjectName, healthMBean);
    }

    private ObjectName createHealthObjectName(ObjectName name) throws JMException {
        return MBeanUtils.getHealthObjectName(name);
    }

    public void createHealthMBeans() {
        MBeanRepository metricBeanRepository = ConsolidatedHealthMBeanCollection.createMetricGroupRepository(this.mBeanRepository);
        Iterator<Map.Entry<ObjectName, DynamicMBean>> iter = metricBeanRepository.iterator();
        while (iter.hasNext()) {
            Map.Entry<ObjectName, DynamicMBean> entry = iter.next();
            this.createHealthMBean(entry.getKey(), (NotifyingDynamicMBean)entry.getValue());
        }
    }

    static MBeanRepository createMetricGroupRepository(MBeanRepository repository) {
        MBeanRepository metricBeanRepository = repository.createFilteredRepository(new MBeanRepositoryFilter(){

            @Override
            public boolean matches(ObjectName objectName, DynamicMBean mBean) {
                return objectName.getKeyProperty("type").equals("Metrics") && objectName.getKeyProperty("group") != null;
            }
        });
        return metricBeanRepository;
    }
}

