/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.threshold;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.monitoring.jmx.threshold.MBeanHealth;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdAttribute;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdComparable;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdHealth;
import com.cognos.pogo.util.threads.SafeTimerTask;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.DynamicMBean;
import javax.management.MBeanInfo;
import javax.management.Notification;

public class DispatcherMBeanHealth
extends MBeanHealth {
    protected final DynamicMBean metricMBean;
    protected long pollingInterval = 30000L;
    protected static Timer timer = new Timer(true);

    public DispatcherMBeanHealth(MBeanInfo mBeanInfo, String serviceName, DynamicMBean metricMBean) {
        super(mBeanInfo, serviceName);
        this.metricMBean = metricMBean;
        String property = PropertyInserter.getProperty("ConsolidatedHealthPolling");
        if (property != null && property.length() != 0) {
            try {
                this.pollingInterval = Long.parseLong(property) * 1000L;
            }
            catch (NumberFormatException e) {
                cat.warn("ConsolidatedHealthPolling is invalid: " + property + " Default used: " + this.pollingInterval);
            }
        }
        this.createTimer();
    }

    protected void createTimer() {
        timer.schedule((TimerTask)new Poller(), 0L, this.pollingInterval);
    }

    protected void checkThresholds() {
        if (this.thresholdAttributeList.size() == 0) {
            return;
        }
        AttributeList attributeList = this.metricMBean.getAttributes(this.thresholdAttributeList.getAttributeNames());
        for (Attribute attribute : attributeList.asList()) {
            Comparable value;
            ThresholdComparable comparable;
            String name = attribute.getName();
            ThresholdAttribute thresholdAttribute = this.thresholdAttributeList.get(name);
            ThresholdHealth newHealth = thresholdAttribute.check(comparable = ThresholdComparable.createThresholdComparable(value = (Comparable)attribute.getValue()));
            if (newHealth == null) continue;
            AttributeChangeNotification notification = this.createNotification(name, thresholdAttribute.getOldValue(), value);
            this.fillNotification(notification, thresholdAttribute, newHealth);
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification.getType().equals("reset")) {
            this.checkThresholds();
        } else {
            super.handleNotification(notification, handback);
        }
    }

    private class Poller
    extends SafeTimerTask {
        private Poller() {
        }

        @Override
        public void safeRun() {
            DispatcherMBeanHealth.this.checkThresholds();
        }
    }
}

