/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.threshold;

import com.cognos.pogo.monitoring.jmx.MBeanRepository;
import com.cognos.pogo.monitoring.jmx.threshold.ConsolidatedThresholdManager;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import java.util.Hashtable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ProxyThresholdManager
implements DynamicMBean {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ProxyThresholdManager.class.getName());
    private final MBeanRepository mBeanRepository;
    private MBeanInfo mBeanInfo;
    private ConsolidatedThresholdManager consolidatedThresholdManager;

    public ProxyThresholdManager(MBeanRepository repository, MBeanInfo mBeanInfo, ConsolidatedThresholdManager consolidatedThresholdManager) {
        this.mBeanRepository = repository;
        this.mBeanInfo = mBeanInfo;
        this.consolidatedThresholdManager = consolidatedThresholdManager;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return null;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        return null;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName.equals("readThreshold") || actionName.equals("writeThreshold") || actionName.equals("clearThreshold")) {
            return this.mBeanInvoke(actionName, params, signature);
        }
        return null;
    }

    private Object mBeanInvoke(String actionName, Object[] params, String[] signature) throws MBeanException {
        String mbeanName = (String)params[0];
        try {
            ObjectName mbeanObjectName = new ObjectName(mbeanName);
            Hashtable<String, String> keyPropertyList = mbeanObjectName.getKeyPropertyList();
            String dispatcherName = keyPropertyList.remove("dispatcher");
            if (dispatcherName == null) {
                return this.relayToConsolidated(actionName, params, signature);
            }
            if (keyPropertyList.containsKey("type") && !keyPropertyList.containsKey("service")) {
                keyPropertyList.put("dispatcher", dispatcherName);
            }
            ObjectName remoteMBean = ObjectName.getInstance(mbeanObjectName.getDomain(), keyPropertyList);
            params[0] = remoteMBean.toString();
            DynamicMBean remoteThresholdManager = this.getThresholdManager(dispatcherName);
            return remoteThresholdManager.invoke(actionName, params, signature);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    private DynamicMBean getThresholdManager(String dispatcherName) throws MalformedObjectNameException {
        ObjectName proxy = MBeanUtils.createObjectNameInstance("type=ThresholdManager,dispatcher=" + dispatcherName);
        DynamicMBean remoteThresholdManager = this.mBeanRepository.get(proxy);
        return remoteThresholdManager;
    }

    private Object relayToConsolidated(String actionName, Object[] params, String[] signature) throws Exception {
        return this.consolidatedThresholdManager.invoke(actionName, params, signature);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mBeanInfo;
    }
}

