/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.threshold;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTypedLogger;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ThresholdLoggingReceiver
implements NotificationListener {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ThresholdLoggingReceiver.class.getName());

    @Override
    public void handleNotification(Notification notification, Object handback) {
        LogTypedLogger thresholdlog;
        if (cat.isDebugEnabled()) {
            cat.debug("notification:" + notification);
        }
        if ((thresholdlog = LogTypedLogger.getInstance((String)"Audit.Dispatcher.ThresholdViolation", LogAuditIndication.class)).isEnabled(50000)) {
            LogAuditAccessIndication aaind = new LogAuditAccessIndication("DISP", 200);
            aaind.setLevel(50000);
            aaind.setPort(8081);
            aaind.setOperation("ThresholdViolation");
            Map nd = (Map)notification.getUserData();
            StringBuffer data = new StringBuffer("<parameters>");
            this.addItemData(nd, data, "ResourceType", "service");
            this.addItemData(nd, data, "ResourcePath", "path");
            this.addItemData(nd, data, "MetricName", "attribute");
            this.addItemData(nd, data, "MetricValue", "value");
            this.addItemData(nd, data, "MetricHealth", "health");
            this.addItemData(nd, data, "LowerSideAverageThreshold", "lowerSideAverage");
            this.addItemData(nd, data, "LowerSideAverageThresholdExclusive", "lowerSideAverageExclusiveFlag");
            this.addItemData(nd, data, "LowerSidePoorThreshold", "lowerSidePoor");
            this.addItemData(nd, data, "LowerSidePoorThresholdExclusive", "lowerSidePoorExclusiveFlag");
            this.addItemData(nd, data, "UpperSideAverageThreshold", "higherSidePoor");
            this.addItemData(nd, data, "UpperSideAverageThresholdExclusive", "higherSidePoorExclusiveFlag");
            this.addItemData(nd, data, "UpperSidePoorThreshold", "higherSideAverage");
            this.addItemData(nd, data, "UpperSidePoorThresholdExclusive", "higherSideAverageExclusiveFlag");
            data.append("</parameters>");
            aaind.setLogData(data.toString());
            aaind.setObjectType("Threshold_Manager");
            aaind.setObjectPath("/configuration/folder[@objectClass='server1']/dispatcher");
            thresholdlog.log((Object)aaind);
        }
    }

    private void addItemData(Map<String, Object> nd, StringBuffer data, String itemName, String dataName) {
        Object itemValue = nd.get(dataName);
        if (itemValue != null) {
            data.append("<item name=\"").append(itemName).append("\"><![CDATA[").append(itemValue).append("]]></item>");
        }
    }
}

