/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.threshold;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.pogo.contentmanager.ContentManagerAddCommand;
import com.cognos.pogo.contentmanager.ContentManagerDeleteCommand;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdManager;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdParameters;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class ThresholdPersister {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ThresholdPersister.class.getName());
    private static final String ATTRIBUTE_SEPERATOR = ",attribute=";
    private static final String CONFIGURATION = "/configuration";
    private String localSearchPath;

    public void writeToCM(String mbeanName, String attributeName, ThresholdParameters thresholdParameters2) throws MalformedObjectNameException, CommandExecutionException {
        ContentManagerAddCommand addCmd = new ContentManagerAddCommand();
        addCmd.addObject("systemMetricThresholds");
        addCmd.setDefaultName(this.generateDefaultName(mbeanName, attributeName));
        addCmd.setSearch(this.generateSearchPath(mbeanName));
        addCmd.setSystemMetricThresholds(attributeName, thresholdParameters2);
        addCmd.setUpdateAction("update");
        addCmd.setDoTrustedRequest(true);
        try {
            addCmd.execute();
        }
        catch (CommandExecutionException e) {
            cat.error("Exception adding threshold to CM", (Throwable)e);
            throw e;
        }
    }

    private String generateDefaultName(String mbeanName, String attributeName) throws MalformedObjectNameException, NullPointerException {
        String canonicalName = ObjectName.getInstance(mbeanName).getCanonicalName();
        String defaultName = canonicalName + ATTRIBUTE_SEPERATOR + attributeName;
        return this.normalize(defaultName);
    }

    private String normalize(String defaultName) {
        return defaultName.replaceAll("\"", "&quot;");
    }

    private String generateSearchPath(String mbeanName) throws MalformedObjectNameException {
        ObjectName mBeanObjectName = ObjectName.getInstance(mbeanName);
        if (mBeanObjectName.getKeyProperty("group") != null) {
            return CONFIGURATION;
        }
        return this.localSearchPath;
    }

    public void setLocalSearchPath(String localSearchPath) {
        this.localSearchPath = localSearchPath;
    }

    public void recreateThresholds(ThresholdManager thresholdManager) {
        this.recreateThresholdsForPath(thresholdManager, this.localSearchPath + "/systemMetricThresholds");
    }

    public void recreateConsolidatedThresholds(ThresholdManager thresholdManager) {
        this.recreateThresholdsForPath(thresholdManager, "/configuration/systemMetricThresholds");
    }

    private void recreateThresholdsForPath(ThresholdManager thresholdManager, String path) {
        ContentManagerQueryCommand queryCmd = new ContentManagerQueryCommand(path);
        queryCmd.addQueryPropertyName("defaultName");
        ThresholdParameters.addThresholdsToQuery(queryCmd);
        queryCmd.setDoTrustedRequest(true);
        try {
            queryCmd.execute();
            for (CMClass cmClass : queryCmd.getResultList()) {
                Element node = (Element)cmClass.getPropertyAsElement("defaultName").selectSingleNode("value");
                String text = node.getTextTrim().replaceAll("&quot;", "\"");
                int attributePos = text.indexOf(ATTRIBUTE_SEPERATOR);
                if (attributePos == -1) continue;
                String mBeanName = text.substring(0, attributePos);
                String attributeName = text.substring(attributePos + ATTRIBUTE_SEPERATOR.length());
                try {
                    ThresholdParameters thresholdParameters = ThresholdParameters.create(cmClass.getItemElement());
                    thresholdManager.createThreshold(mBeanName, attributeName, thresholdParameters);
                    if (!cat.isInfoEnabled()) continue;
                    StringBuffer strBuf = new StringBuffer("Created threshold MBean= ");
                    strBuf.append(mBeanName);
                    strBuf.append(" attribute = ").append(attributeName);
                    strBuf.append(" parameters = ").append(thresholdParameters);
                    cat.info(strBuf.toString());
                }
                catch (Exception e) {
                    cat.info("Cannot create threshold for " + text, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            cat.error("Error reading thresholds from CM", (Throwable)e);
        }
    }

    public void remove(String mbeanName, String attributeName) throws MalformedObjectNameException, CommandExecutionException {
        String searchFolder = this.generateSearchPath(mbeanName);
        if (searchFolder == null) {
            return;
        }
        ContentManagerDeleteCommand deleteCmd = new ContentManagerDeleteCommand();
        deleteCmd.addObject("systemMetricThresholds");
        StringBuffer searchPath = new StringBuffer(searchFolder);
        searchPath.append("/systemMetricThresholds[@name='");
        searchPath.append(this.generateDefaultName(mbeanName, attributeName));
        searchPath.append("']");
        String path = searchPath.toString();
        deleteCmd.setSearchPath(path);
        deleteCmd.setDoTrustedRequest(true);
        try {
            deleteCmd.execute();
        }
        catch (CommandExecutionException e) {
            cat.error("Exception deleteing threshold from CM", (Throwable)e);
            throw e;
        }
    }
}

