/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.osgi.launcher;

import com.cognos.pogo.osgi.launcher.BundleDirectoryInstaller;
import com.cognos.pogo.util.timer.PogoTimer;
import com.cognos.pogo.util.timer.PogoTimerOwner;
import java.io.File;
import java.util.ArrayList;
import org.osgi.framework.BundleContext;

public class BundleDirectoryWatcher
extends BundleDirectoryInstaller
implements PogoTimerOwner {
    private static final long timeoutInMillis = 5000L;
    private BundleContext bundleContext;
    private PogoTimer timer;

    public BundleDirectoryWatcher(String directory, BundleContext bundleContext) {
        super(directory);
        this.bundleContext = bundleContext;
    }

    public void watch() {
        this.timer = new PogoTimer(this, null, 0L, 5000L);
    }

    public void synchronize() {
        this.directoryWatcher.scanDirectory();
        this.synchronizeFiles();
        this.watchedBundles.startInstalled();
        this.directoryWatcher.setFileModifiedTimes();
    }

    private void synchronizeFiles() {
        ArrayList<File> filesToAdd = this.directoryWatcher.getFilesToAdd();
        ArrayList<File> filesToUpdate = this.directoryWatcher.getFilesToUpdate();
        ArrayList<File> filesToRemove = this.directoryWatcher.getFilesToRemove();
        this.removeFiles(filesToRemove);
        this.removeFiles(filesToUpdate);
        this.addfiles(filesToUpdate);
        this.addfiles(filesToAdd);
    }

    void removeFiles(ArrayList<File> files) {
        this.watchedBundles.removeFiles(files);
    }

    private void addfiles(ArrayList<File> filesToAdd) {
        this.watchedBundles.installFiles(this.bundleContext, filesToAdd);
    }

    @Override
    public void handleTimeoutEvent(Object parameter) throws Exception {
        this.synchronize();
    }

    public void stop() {
        this.timer.cancel();
    }
}

