/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.osgi.launcher;

import com.cognos.pogo.osgi.launcher.BundleFileListInstaller;
import com.cognos.pogo.osgi.launcher.BundleInstallerHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class BundleFileListInstallerHandler
extends BundleInstallerHandler {
    private static PogoLogger log = PogoLogger.getLogger();
    private String[] bundleList;

    public BundleFileListInstallerHandler() {
        super(log.getNativeLogger());
    }

    @Override
    public void contextualize(Element config) throws PogoException {
        super.contextualize(config);
        this.bundleList = this.getBundleList(config);
    }

    private String[] getBundleList(Element config) {
        ArrayList<String> bundles = new ArrayList<String>();
        List elements = config.element("bundles").elements("bundle");
        for (Element element : elements) {
            bundles.add(element.getTextTrim());
        }
        String[] bundlesAsArray = bundles.toArray(new String[bundles.size()]);
        return bundlesAsArray;
    }

    @Override
    public void start() {
        super.start();
        BundleFileListInstaller dsBundleInstaller = new BundleFileListInstaller(this.directory, this.bundleList);
        dsBundleInstaller.install(this.bundleContext);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
    }

    public String getDirectoryLocationForTesting() {
        return this.directory;
    }

    public String[] getBundleListForTesting() {
        return this.bundleList;
    }
}

