/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.osgi.launcher;

import com.cognos.cclcfgapi.CCLConfigurationUtils;
import com.cognos.pogo.util.PogoLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class DirectoryWatcher {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final List<File> EMPTY_LIST = Collections.emptyList();
    private String directoryPath;
    private HashMap<File, Long> fileModifiedTimes = new HashMap();
    private List<File> currentFiles;

    public DirectoryWatcher(String directory) {
        this.directoryPath = this.resolvePath(directory);
    }

    private String resolvePath(String path) {
        File directory = new File(path);
        if (directory.isAbsolute()) {
            return path;
        }
        return CCLConfigurationUtils.resolveEffectivePath((String)("../" + path));
    }

    public void scanDirectory() {
        File directoryFile = new File(this.directoryPath);
        File[] matchingFiles = this.listMatchingFiles(directoryFile);
        this.currentFiles = matchingFiles == null ? EMPTY_LIST : Arrays.asList(matchingFiles);
    }

    public List<File> getCurrentFiles() {
        return this.currentFiles;
    }

    protected File[] listMatchingFiles(File directoryFile) {
        return directoryFile.listFiles();
    }

    public String getPath() {
        return this.directoryPath;
    }

    public ArrayList<File> getFilesToAdd() {
        ArrayList<File> filesToAdd = new ArrayList<File>();
        for (File file : this.currentFiles) {
            if (this.fileModifiedTimes.containsKey(file)) continue;
            filesToAdd.add(file);
        }
        return filesToAdd;
    }

    public ArrayList<String> getFileNamesToAdd() {
        ArrayList<String> filesToAdd = new ArrayList<String>();
        for (File file : this.currentFiles) {
            if (this.fileModifiedTimes.containsKey(file)) continue;
            log.debug("File to add: ", file.getAbsolutePath());
            filesToAdd.add(file.getAbsolutePath());
        }
        return filesToAdd;
    }

    public ArrayList<File> getFilesToUpdate() {
        ArrayList<File> filesToUpdate = new ArrayList<File>();
        for (File file : this.currentFiles) {
            long lastModified = file.lastModified();
            if (!this.fileModifiedTimes.containsKey(file) || this.fileModifiedTimes.get(file) == lastModified) continue;
            filesToUpdate.add(file);
        }
        return filesToUpdate;
    }

    public ArrayList<String> getFileNamesToUpdate() {
        ArrayList<String> filesToUpdate = new ArrayList<String>();
        for (File file : this.currentFiles) {
            long lastModified = file.lastModified();
            if (!this.fileModifiedTimes.containsKey(file) || this.fileModifiedTimes.get(file) == lastModified) continue;
            log.debug("File to update: ", file.getAbsolutePath());
            filesToUpdate.add(file.getAbsolutePath());
        }
        return filesToUpdate;
    }

    public ArrayList<File> getFilesToRemove() {
        ArrayList<File> filesToRemove = new ArrayList<File>();
        for (File file : this.fileModifiedTimes.keySet()) {
            if (this.currentFiles.contains(file)) continue;
            filesToRemove.add(file);
        }
        return filesToRemove;
    }

    public ArrayList<String> getFileNamesToRemove() {
        ArrayList<String> filesToRemove = new ArrayList<String>();
        for (File file : this.fileModifiedTimes.keySet()) {
            if (this.currentFiles.contains(file)) continue;
            log.debug("File to remove: ", file.getAbsolutePath());
            filesToRemove.add(file.getAbsolutePath());
        }
        return filesToRemove;
    }

    public void setFileModifiedTimes() {
        this.fileModifiedTimes.clear();
        for (File file : this.currentFiles) {
            this.fileModifiedTimes.put(file, file.lastModified());
        }
    }
}

