/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk;

import com.cognos.pogo.auth.Passport;
import com.cognos.pogo.auth.PassportFactory;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.SOAPException;
import com.cognos.pogo.pdk.common.BiBusHeader;
import com.cognos.pogo.pdk.common.Envelope;
import com.cognos.pogo.pdk.common.SetCookieVar;
import com.cognos.pogo.pdk.common.SetCookieVars;
import com.cognos.pogo.pdk.dom4j.Dom4jBiBusHeader;
import com.cognos.pogo.pdk.util.SOAPPasswordCleaner;
import com.cognos.pogo.util.DomUtils;
import com.cognos.pogo.util.MyCookie;
import com.cognos.pogo.util.NameValuePair;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.URLEncoderDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class BIBusEnvelope
extends SOAPEnvelope
implements Cloneable {
    private static PogoLogger log = PogoLogger.getLogger();
    public static final Namespace NS_BUS = Namespace.get((String)"bus", (String)"http://developer.cognos.com/schemas/bibus/3/");
    public static final String XSD_FORMAT_ENCODING_ENUM = NS_BUS.getPrefix() + ":formatEnum";
    public static final QName BUS_BIBUS_HEADER = DocumentHelper.createQName((String)"biBusHeader", (Namespace)NS_BUS);
    public static final QName BUS_CAM = DocumentHelper.createQName((String)"CAM", (Namespace)NS_BUS);
    public static final QName BUS_CAMPASSPORT = DocumentHelper.createQName((String)"CAMPassport", (Namespace)NS_BUS);
    public static final QName BUS_CAM_SETTINGS = DocumentHelper.createQName((String)"settings", (Namespace)NS_BUS);
    public static final QName BUS_CAM_ACTION = DocumentHelper.createQName((String)"action", (Namespace)NS_BUS);
    public static final QName BUS_CAMPROTECT = DocumentHelper.createQName((String)"CAMProtect", (Namespace)NS_BUS);
    public static final QName BUS_CAMPROT_TRUSTEDVALUE = DocumentHelper.createQName((String)"trustedValue", (Namespace)NS_BUS);
    public static final QName BUS_CAMPROT_SERVICEID = DocumentHelper.createQName((String)"serviceId", (Namespace)NS_BUS);
    public static final QName BUS_HDR_SESSION = DocumentHelper.createQName((String)"hdrSession", (Namespace)NS_BUS);
    public static final QName BUS_TRACKING = DocumentHelper.createQName((String)"tracking", (Namespace)NS_BUS);
    public static final QName BUS_FORM_FIELD_VAR = DocumentHelper.createQName((String)"formFieldVar", (Namespace)NS_BUS);
    public static final QName BUS_FORM_FIELD_VARS = DocumentHelper.createQName((String)"formFieldVars", (Namespace)NS_BUS);
    public static final QName BUS_ENVIRONMENT_VAR = DocumentHelper.createQName((String)"environmentVar", (Namespace)NS_BUS);
    public static final QName BUS_ENVIRONMENT_VARS = DocumentHelper.createQName((String)"environmentVars", (Namespace)NS_BUS);
    public static final QName BUS_COOKIE_VAR = DocumentHelper.createQName((String)"cookieVar", (Namespace)NS_BUS);
    public static final QName BUS_COOKIE_VARS = DocumentHelper.createQName((String)"cookieVars", (Namespace)NS_BUS);
    public static final QName BUS_SET_COOKIE_VAR = DocumentHelper.createQName((String)"setCookieVar", (Namespace)NS_BUS);
    public static final QName BUS_SET_COOKIE_VARS = DocumentHelper.createQName((String)"setCookieVars", (Namespace)NS_BUS);
    public static final QName BUS_USER_PREFERENCE_VAR = DocumentHelper.createQName((String)"userPreferenceVar", (Namespace)NS_BUS);
    public static final QName BUS_USER_PREFERENCE_VARS = DocumentHelper.createQName((String)"userPreferenceVars", (Namespace)NS_BUS);
    public static final QName BUS_DISPATCHER_TRANSPORT_VAR = DocumentHelper.createQName((String)"dispatcherTransportVar", (Namespace)NS_BUS);
    public static final QName BUS_DISPATCHER_TRANSPORT_VARS = DocumentHelper.createQName((String)"dispatcherTransportVars", (Namespace)NS_BUS);
    public static final QName BUS_CAF = DocumentHelper.createQName((String)"CAF", (Namespace)NS_BUS);
    public static final QName BUS_ROUTING = DocumentHelper.createQName((String)"routing", (Namespace)NS_BUS);
    public static final QName BUS_ROUTING_INFO = DocumentHelper.createQName((String)"routingInfo", (Namespace)NS_BUS);
    public static final QName BUS_CAM_AUTHENTICITYTOKEN = DocumentHelper.createQName((String)"authenticityToken", (Namespace)NS_BUS);
    public static final QName BUS_CAM_USERSESSIONID = DocumentHelper.createQName((String)"userSessionID", (Namespace)NS_BUS);
    public static final QName BUS_USER_CAPABILITIES_CACHE = DocumentHelper.createQName((String)"userCapabilityCache", (Namespace)NS_BUS);
    public static final QName BUS_HOP_COUNT = DocumentHelper.createQName((String)"hopCount", (Namespace)NS_BUS);
    public static final QName BUS_SESSION_CONTEXT = DocumentHelper.createQName((String)"sessionContext", (Namespace)NS_BUS);
    public static final QName BUS_REQUEST_CONTEXT = DocumentHelper.createQName((String)"requestContext", (Namespace)NS_BUS);
    public static final QName BUS_STEP_CONTEXT = DocumentHelper.createQName((String)"stepContext", (Namespace)NS_BUS);
    public static final QName BUS_CONVERSATION_CONTEXT = DocumentHelper.createQName((String)"conversationContext", (Namespace)NS_BUS);
    public static final QName BUS_PROVIDERS = DocumentHelper.createQName((String)"providers", (Namespace)NS_BUS);
    public static final QName BUS_PROVIDER = DocumentHelper.createQName((String)"provider", (Namespace)NS_BUS);
    public static final QName BUS_EXCEPTION = DocumentHelper.createQName((String)"exception", (Namespace)NS_BUS);
    public static final QName BUS_MESSAGE = DocumentHelper.createQName((String)"message", (Namespace)NS_BUS);
    public static final QName ITEM = DocumentHelper.createQName((String)"item");
    private static PassportFactory passportFactory = new PassportFactory();
    private String queryStringHint;
    private Passport passport;
    private BiBusHeader biBusHeader;

    public BIBusEnvelope() {
        this(null, null);
    }

    public BIBusEnvelope(Element headerElement) {
        this(headerElement, null);
    }

    public BIBusEnvelope(Element headerElement, Element bodyElement) {
        super(headerElement, bodyElement);
        Element envelope = this.getEnvelope();
        envelope.add(NS_BUS);
        if (headerElement == null) {
            Element tracking = this.getBIBusHeader().addElement(BUS_TRACKING);
            tracking.addAttribute(XSI_TYPE, BUS_TRACKING.getQualifiedName());
        }
    }

    public BIBusEnvelope(Document document) {
        super(document);
    }

    protected BIBusEnvelope(int empty) {
    }

    public BIBusEnvelope(InputStream inStream) throws SOAPException {
        super(inStream);
        Element soapEnvelope = this.getEnvelope();
        soapEnvelope.add(NS_BUS);
    }

    public BIBusEnvelope(Reader aReader) throws SOAPException {
        super(aReader);
        Element soapEnvelope = this.getEnvelope();
        soapEnvelope.add(NS_BUS);
    }

    @Deprecated
    public Element getMandatoryElement(Element parent, QName name) {
        return this.getMandatoryElement(parent, name, name);
    }

    protected Element getMandatoryElement(Element parent, QName elementName, QName dataType) {
        Element theElement = this.getOptionalElement(parent, elementName.getName(), dataType);
        if (theElement == null) {
            theElement = parent.addElement(elementName);
            theElement.addAttribute(XSI_TYPE, dataType.getQualifiedName());
        }
        return theElement;
    }

    private Element getOptionalElement(Element parent, QName name) {
        return this.getOptionalElement(parent, name.getName(), name);
    }

    protected Element getOptionalElement(Element parent, String elementName, QName dataType) {
        Element theElement = parent.element(dataType);
        if (theElement != null) {
            return theElement;
        }
        theElement = parent.element(elementName);
        if (theElement == null) {
            return null;
        }
        String type = theElement.attributeValue(XSI_TYPE);
        if (type == null) {
            return theElement;
        }
        int colonPos = type.indexOf(58);
        if (colonPos == -1) {
            return null;
        }
        String prefix = type.substring(0, colonPos);
        String typeName = type.substring(colonPos + 1);
        Namespace theNameSpace = theElement.getNamespaceForPrefix(prefix);
        Attribute arrayTypeAttribute = theElement.attribute("arrayType");
        if (arrayTypeAttribute != null && NS_SOAP_ENC.getURI().equals(arrayTypeAttribute.getNamespace().getURI()) && "Array".equals(typeName)) {
            return theElement;
        }
        if (theNameSpace == null) {
            if (log.isDebugEnabled()) {
                if (prefix == null) {
                    log.debug("Unable to resolve SOAP type for " + theElement.getName() + " since no type prefix is declared");
                } else {
                    log.debug("The namespace prefix " + prefix + " has not been defined");
                }
            }
            return null;
        }
        if (!dataType.getNamespace().getURI().equals(theNameSpace.getURI())) {
            return null;
        }
        return theElement;
    }

    public boolean hasOptionalElement(QName qname) {
        return this.getOptionalElement(this.getBIBusHeader(), qname.getName(), qname) != null;
    }

    @Override
    public void moveBiBusHeaderTo(Envelope target) {
        this.getHeader();
        this.transferHeaderTo((SOAPEnvelope)target);
    }

    @Override
    public void copyBiBusHeaderTo(Envelope target) {
        BIBusEnvelope biBusTarget = (BIBusEnvelope)target;
        Element biBusHeader = this.getBIBusHeader().createCopy();
        biBusTarget.setBIBusHeader(biBusHeader);
        this.copyNamespacesTo(biBusTarget);
    }

    @Override
    public BiBusHeader getBiBusHeader() {
        if (this.biBusHeader == null) {
            this.setBiBusHeader(new Dom4jBiBusHeader(this));
        }
        return this.biBusHeader;
    }

    public void setBiBusHeader(BiBusHeader biBusHeader) {
        this.biBusHeader = biBusHeader;
    }

    @Deprecated
    public Element getBIBusHeader() {
        return this.getMandatoryElement(this.getHeader(), BUS_BIBUS_HEADER);
    }

    public void setBIBusHeader(Element newBiBusHeader) {
        Element header = this.getHeader();
        Element biBusHeader = header.element(BUS_BIBUS_HEADER);
        if (biBusHeader != null) {
            biBusHeader.detach();
        }
        header.add(newBiBusHeader);
    }

    @Deprecated
    public Element getCAM() {
        return this.getMandatoryElement(this.getBIBusHeader(), BUS_CAM);
    }

    @Deprecated
    public Element getOptionalCAM() {
        return this.getOptionalElement(this.getBIBusHeader(), BUS_CAM);
    }

    @Deprecated
    public void setCAM(Element camElement) {
        Element biBusHeader = this.getBIBusHeader();
        Element cam = biBusHeader.element(BUS_CAM);
        if (cam != null) {
            cam.detach();
        }
        biBusHeader.add(camElement);
    }

    public String getPassportID() {
        return this.getBiBusHeader().getCam().getCAMPassport().getId();
    }

    public boolean getLogEnabled() {
        return this.getBiBusHeader().getCam().getCAMPassport().isLogEnabled();
    }

    @Deprecated
    public Element getCAMProtect() {
        return this.getOptionalElement(this.getBIBusHeader(), BUS_CAMPROTECT);
    }

    @Deprecated
    public Element getTracking() {
        return this.getMandatoryElement(this.getBIBusHeader(), BUS_TRACKING);
    }

    public int getHopCount() {
        return (int)this.getBiBusHeader().getTracking().getHopCount();
    }

    public String getTrackingRequestContext() {
        return this.getBiBusHeader().getTracking().getRequestContext();
    }

    public void setTracking(Element trackingElement) {
        Element biBusHeader = this.getBIBusHeader();
        Element tracking = this.getOptionalElement(biBusHeader, BUS_TRACKING);
        if (tracking != null) {
            tracking.detach();
        }
        biBusHeader.add(trackingElement);
    }

    @Deprecated
    public Element getHdrSession() {
        return this.getMandatoryElement(this.getBIBusHeader(), BUS_HDR_SESSION);
    }

    public void setHdrSession(Element hdrSessionElement) {
        Element biBusHeader = this.getBIBusHeader();
        Element hdrSession = biBusHeader.element(BUS_HDR_SESSION);
        if (hdrSession != null) {
            hdrSession.detach();
        }
        biBusHeader.add(hdrSessionElement);
    }

    @Deprecated
    public Element getFormFieldVars() {
        Element hdrSession = this.getHdrSession();
        Element formFieldVars = this.getOptionalElement(hdrSession, BUS_FORM_FIELD_VARS);
        BIBusEnvelope.stripXSINilAttribute(hdrSession);
        if (formFieldVars == null) {
            formFieldVars = hdrSession.addElement(BUS_FORM_FIELD_VARS);
        }
        if (formFieldVars.attribute(XSI_TYPE) == null || formFieldVars.attribute(SOAP_ENC_ARRAYTYPE) == null) {
            this.addRequiredEnvNamespaces(formFieldVars);
            formFieldVars.addAttribute(XSI_TYPE, SOAP_ENC_ARRAY);
            formFieldVars.addAttribute(SOAP_ENC_ARRAYTYPE, BUS_FORM_FIELD_VAR.getQualifiedName() + "[]");
        }
        return formFieldVars;
    }

    public List<NameValuePair> getFormFieldValues() {
        Element formFieldVars = this.getFormFieldVars();
        List itemList = formFieldVars.elements();
        ArrayList<NameValuePair> aList = new ArrayList<NameValuePair>(itemList.size());
        for (Element itemElement : itemList) {
            Element nameElement = itemElement.element("name");
            if (nameElement == null) continue;
            NameValuePair pair = new NameValuePair();
            pair.setName(nameElement.getText());
            aList.add(pair);
            Element valueElement = itemElement.element("value");
            if (valueElement == null) continue;
            pair.setValue(valueElement.getText());
        }
        return aList;
    }

    public String getFormFieldValuesAsQueryString() {
        String qryString = null;
        try {
            qryString = this.getFormFieldValuesAsQueryString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return qryString;
    }

    public String getFormFieldValuesAsQueryString(String encoding) throws UnsupportedEncodingException {
        if (this.queryStringHint != null) {
            return this.queryStringHint;
        }
        StringBuffer queryStringBuffer = new StringBuffer(256);
        for (NameValuePair formField : this.getBiBusHeader().getHdrSession().getFormFieldVars().getNamesAndValues()) {
            if (queryStringBuffer.length() > 0) {
                queryStringBuffer.append('&');
            }
            queryStringBuffer.append(this.encode(formField.getName(), encoding));
            queryStringBuffer.append('=');
            String formValue = formField.getValue();
            if (formValue == null) continue;
            queryStringBuffer.append(this.encode(formValue, encoding));
        }
        return queryStringBuffer.toString();
    }

    private String encode(String s, String encoding) throws UnsupportedEncodingException {
        try {
            return URLEncoderDecoder.encode(s, encoding);
        }
        catch (UnsupportedEncodingException e) {
            log.error("Error encoding [" + s + "] as " + encoding, e);
            throw e;
        }
    }

    public void setQueryStringHint(String hint) {
        this.queryStringHint = hint;
    }

    public String getFormValue(String name) {
        return this.getFormFieldParameter(this.getFormFieldVars(), name, "value");
    }

    public String getFormFormat(String name) {
        return this.getFormFieldParameter(this.getFormFieldVars(), name, "format");
    }

    public void removeFormValue(String name) {
        DomUtils.removeNameValuePair(this.getFormFieldVars(), name);
    }

    public void setFormField(String name, String value) {
        this.setFormField(name, value, null);
    }

    public void setFormField(String name, String value, String format) {
        Element item = this.getOrCreateItem(this.getFormFieldVars(), name);
        this.setChildElements(item, name, value, format);
    }

    private Element getOrCreateItem(Element parent, String name) {
        Element item = DomUtils.getItemElementWithName(parent, name);
        if (item == null) {
            item = parent.addElement(ITEM);
            item.addAttribute(XSI_TYPE, BUS_FORM_FIELD_VAR.getQualifiedName());
            BIBusEnvelope.stripXSINilAttribute(parent);
        }
        return item;
    }

    private void setChildElements(Element item, String name, String value, String format) {
        this.setChildElement(item, "name", name, XSD_STRING);
        this.setChildElement(item, "value", value, XSD_STRING);
        this.setChildElement(item, "format", format, XSD_FORMAT_ENCODING_ENUM);
        this.queryStringHint = null;
    }

    private void setChildElement(Element parent, String name, String value, String type) {
        if (value != null) {
            Element childElement = parent.element(name);
            if (childElement == null) {
                childElement = parent.addElement(name);
                childElement.addAttribute(XSI_TYPE, type);
            }
            childElement.setText(value);
        }
    }

    public void addFormField(String name, String value, String format) {
        Element item = this.addItemTo(this.getFormFieldVars());
        this.setChildElements(item, name, value, format);
    }

    private Element addItemTo(Element parent) {
        Element item = parent.addElement(ITEM);
        item.addAttribute(XSI_TYPE, BUS_FORM_FIELD_VAR.getQualifiedName());
        BIBusEnvelope.stripXSINilAttribute(parent);
        return item;
    }

    private String getValueFromNameValuePair(Element parent, String name) {
        return this.getFormFieldParameter(parent, name, "value");
    }

    private String getFormFieldParameter(Element parent, String name, String parameter) {
        if (parent == null || name == null) {
            return null;
        }
        Element itemElement = DomUtils.getItemElementWithName(parent, name);
        if (itemElement == null) {
            return null;
        }
        return itemElement.elementText(parameter);
    }

    public static Element setNameValuePair(Element parent, String name, String value, QName type) {
        Element item = DomUtils.getItemElementWithName(parent, name);
        if (item != null) {
            item.element("value").setText(value);
        } else {
            item = parent.addElement(ITEM);
            Element nameElement = item.addElement("name");
            nameElement.addAttribute(XSI_TYPE, XSD_STRING);
            nameElement.setText(name);
            Element valueElement = item.addElement("value");
            valueElement.addAttribute(XSI_TYPE, XSD_STRING);
            valueElement.setText(value);
            item.addAttribute(XSI_TYPE, type.getQualifiedName());
            parent.add(NS_BUS);
        }
        return item;
    }

    @Deprecated
    public Element getEnvironmentVars() {
        Element hdrSession = this.getHdrSession();
        Element environmentVars = this.getOptionalElement(hdrSession, BUS_ENVIRONMENT_VARS);
        BIBusEnvelope.stripXSINilAttribute(hdrSession);
        if (environmentVars == null) {
            environmentVars = hdrSession.addElement(BUS_ENVIRONMENT_VARS);
        }
        if (environmentVars.attribute(XSI_TYPE) == null || environmentVars.attribute(SOAP_ENC_ARRAYTYPE) == null) {
            this.addRequiredEnvNamespaces(environmentVars);
            environmentVars.addAttribute(XSI_TYPE, SOAP_ENC_ARRAY);
            environmentVars.addAttribute(SOAP_ENC_ARRAYTYPE, BUS_ENVIRONMENT_VAR.getQualifiedName() + "[]");
        }
        return environmentVars;
    }

    public String getEnvironmentValue(String name) {
        return this.getValueFromNameValuePair(this.getEnvironmentVars(), name);
    }

    public void setEnvironment(String name, String value) {
        Element environmentVars = this.getEnvironmentVars();
        BIBusEnvelope.stripXSINilAttribute(environmentVars);
        BIBusEnvelope.setEnvironmentVar(environmentVars, name, value);
    }

    public static void setEnvironmentVar(Element environmentVars, String name, String value) {
        BIBusEnvelope.setNameValuePair(environmentVars, name, value, BUS_ENVIRONMENT_VAR);
    }

    @Deprecated
    public Element getCookieVars() {
        Element hdrSession = this.getHdrSession();
        Element cookieVars = this.getOptionalElement(hdrSession, BUS_COOKIE_VARS);
        BIBusEnvelope.stripXSINilAttribute(hdrSession);
        if (cookieVars == null) {
            cookieVars = hdrSession.addElement(BUS_COOKIE_VARS);
        }
        if (cookieVars.attribute(XSI_TYPE) == null || cookieVars.attribute(SOAP_ENC_ARRAYTYPE) == null) {
            this.addRequiredEnvNamespaces(cookieVars);
            cookieVars.addAttribute(XSI_TYPE, SOAP_ENC_ARRAY);
            cookieVars.addAttribute(SOAP_ENC_ARRAYTYPE, BUS_COOKIE_VAR.getQualifiedName() + "[]");
        }
        return cookieVars;
    }

    @Override
    public String getCookieValue(String name) {
        return this.getValueFromNameValuePair(this.getCookieVars(), name);
    }

    @Override
    public void setCookie(String name, String value) {
        Element cookieVars = this.getCookieVars();
        BIBusEnvelope.stripXSINilAttribute(cookieVars);
        BIBusEnvelope.setNameValuePair(cookieVars, name, value, BUS_COOKIE_VAR);
    }

    @Deprecated
    public Element getSetCookieVars() {
        Element hdrSession = this.getHdrSession();
        Element setCookieVars = this.getOptionalElement(hdrSession, BUS_SET_COOKIE_VARS);
        if (setCookieVars == null) {
            setCookieVars = hdrSession.addElement(BUS_SET_COOKIE_VARS);
        }
        if (setCookieVars.attribute(XSI_TYPE) == null || setCookieVars.attribute(SOAP_ENC_ARRAYTYPE) == null) {
            this.addRequiredEnvNamespaces(setCookieVars);
            setCookieVars.addAttribute(XSI_TYPE, SOAP_ENC_ARRAY);
            setCookieVars.addAttribute(SOAP_ENC_ARRAYTYPE, BUS_SET_COOKIE_VAR.getQualifiedName() + "[]");
        }
        return setCookieVars;
    }

    public String getSetCookieValue(String name) {
        return this.getValueFromNameValuePair(this.getSetCookieVars(), name);
    }

    @Deprecated
    public Element getSetCookieVar(String name) {
        return name != null ? DomUtils.getItemElementWithName(this.getSetCookieVars(), name) : null;
    }

    @Deprecated
    public Element setSetCookie(String name, String value) {
        return this.setSetCookie(name, value, 0);
    }

    @Deprecated
    public Element setSetCookie(String name, String value, int maxAge) {
        Element setCookieVarsElement = this.getSetCookieVars();
        BIBusEnvelope.stripXSINilAttribute(setCookieVarsElement);
        Element item = BIBusEnvelope.setNameValuePair(setCookieVarsElement, name, value, BUS_SET_COOKIE_VAR);
        Element maxAgeElement = item.element("maxAge");
        if (maxAgeElement == null) {
            maxAgeElement = item.addElement("maxAge");
            maxAgeElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_INT);
        }
        maxAgeElement.setText(String.valueOf(maxAge));
        setCookieVarsElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BUS_SET_COOKIE_VAR.getQualifiedName() + "[]");
        return item;
    }

    @Deprecated
    public Element getUserPreferenceVars() {
        Element biBusHeader = this.getBIBusHeader();
        Element userPreferenceVars = this.getOptionalElement(biBusHeader, BUS_USER_PREFERENCE_VARS);
        BIBusEnvelope.stripXSINilAttribute(biBusHeader);
        return this.buildUserPreferenceVars(userPreferenceVars, biBusHeader);
    }

    @Deprecated
    public Element buildUserPreferenceVars(Element userPrefVars, Element biBusHeader) {
        Element userPreferenceVars = userPrefVars;
        if (userPreferenceVars == null) {
            userPreferenceVars = biBusHeader.addElement(BUS_USER_PREFERENCE_VARS);
        }
        if (userPreferenceVars.attribute(XSI_TYPE) == null || userPreferenceVars.attribute(SOAP_ENC_ARRAYTYPE) == null) {
            this.addRequiredEnvNamespaces(userPreferenceVars);
            userPreferenceVars.addAttribute(XSI_TYPE, SOAP_ENC_ARRAY);
            userPreferenceVars.addAttribute(SOAP_ENC_ARRAYTYPE, BUS_USER_PREFERENCE_VAR.getQualifiedName() + "[]");
        }
        return userPreferenceVars;
    }

    public String getUserPreferenceValue(String name) {
        return this.getValueFromNameValuePair(this.getUserPreferenceVars(), name);
    }

    @Deprecated
    public void setUserPreferenceVars(Element userPreferenceVarsElement) {
        Element biBusHeader = this.getBIBusHeader();
        Element userPreferenceVars = biBusHeader.element(BUS_USER_PREFERENCE_VARS);
        if (userPreferenceVars != null) {
            userPreferenceVars.detach();
        }
        biBusHeader.add(userPreferenceVarsElement);
        BIBusEnvelope.stripXSINilAttribute(biBusHeader);
    }

    public void setUserPreference(String name, String value) {
        Element userPrefVars = this.getUserPreferenceVars();
        BIBusEnvelope.stripXSINilAttribute(userPrefVars);
        BIBusEnvelope.setNameValuePair(userPrefVars, name, value, BUS_USER_PREFERENCE_VAR);
    }

    public void addRequiredEnvNamespaces(Element element) {
        Namespace busNS;
        Namespace encNS;
        if (element == null) {
            element = this.getEnvelope();
        }
        if ((encNS = element.getNamespaceForPrefix(NS_SOAP_ENC.getPrefix())) == null) {
            this.getEnvelope().add(NS_SOAP_ENC);
        }
        if ((busNS = element.getNamespaceForPrefix(NS_BUS.getPrefix())) == null) {
            this.getEnvelope().add(NS_BUS);
        }
    }

    @Deprecated
    public Element getDispatcherTransportVars() {
        Element biBusHeader = this.getBIBusHeader();
        Element dispatcherTransportVars = this.getOptionalElement(this.getBIBusHeader(), BUS_DISPATCHER_TRANSPORT_VARS);
        BIBusEnvelope.stripXSINilAttribute(biBusHeader);
        if (dispatcherTransportVars == null) {
            dispatcherTransportVars = biBusHeader.addElement(BUS_DISPATCHER_TRANSPORT_VARS);
        }
        if (dispatcherTransportVars.attribute(XSI_TYPE) == null || dispatcherTransportVars.attribute(SOAP_ENC_ARRAYTYPE) == null) {
            this.addRequiredEnvNamespaces(dispatcherTransportVars);
            dispatcherTransportVars.addAttribute(XSI_TYPE, SOAP_ENC_ARRAY);
            dispatcherTransportVars.addAttribute(SOAP_ENC_ARRAYTYPE, BUS_DISPATCHER_TRANSPORT_VAR.getQualifiedName() + "[]");
        }
        return dispatcherTransportVars;
    }

    public String getDispatcherTransportValue(String name) {
        return this.getValueFromNameValuePair(this.getDispatcherTransportVars(), name);
    }

    public void setDispatcherTransport(String name, String value) {
        Element transportVars = this.getDispatcherTransportVars();
        BIBusEnvelope.stripXSINilAttribute(transportVars);
        BIBusEnvelope.setNameValuePair(transportVars, name, value, BUS_DISPATCHER_TRANSPORT_VAR);
    }

    public void removeDispatcherTransport(String name) {
        Element transportVars = this.getDispatcherTransportVars();
        BIBusEnvelope.stripXSINilAttribute(transportVars);
        DomUtils.removeNameValuePair(transportVars, name);
        transportVars.addAttribute(SOAP_ENC_ARRAYTYPE, BUS_DISPATCHER_TRANSPORT_VAR.getQualifiedName() + "[]");
    }

    public void setRequestContext(String reqContext) {
        this.getBiBusHeader().getTracking().setRequestContext(reqContext);
    }

    public void setSessionContext(String sessionContext) {
        this.getBiBusHeader().getTracking().setSessionContext(sessionContext);
    }

    public String getConversationContextID() {
        return this.getBiBusHeader().getTracking().getConversationContext().getId();
    }

    @Deprecated
    public Element getConversationContext() {
        return this.getMandatoryElement(this.getTracking(), BUS_CONVERSATION_CONTEXT);
    }

    public void setConversationContextID(String id) {
        this.getBiBusHeader().getTracking().getConversationContext().setId(id);
    }

    public String getConversationContextStatus() {
        return this.getBiBusHeader().getTracking().getConversationContext().getStatus();
    }

    public String getSessionContext() {
        return this.getBiBusHeader().getTracking().getSessionContext();
    }

    public String getRequestContext() {
        return this.getTrackingRequestContext();
    }

    public void setConversationContextStatus(String status) {
        this.getBiBusHeader().getTracking().getConversationContext().setStatus(status);
    }

    public int getConversationContextAffinityStrength() {
        return this.getBiBusHeader().getTracking().getConversationContext().getAffinityStrength();
    }

    public void setConversationContextAffinityStrength(int strength) {
        this.getBiBusHeader().getTracking().getConversationContext().setAffinityStrength(strength);
    }

    public String getConversationContextNodeID() {
        return this.getBiBusHeader().getTracking().getConversationContext().getNodeId();
    }

    public void setConversationContextNodeID(String nodeID) {
        this.getBiBusHeader().getTracking().getConversationContext().setNodeId(nodeID);
    }

    public void clearConversationContext() {
        this.getBiBusHeader().getTracking().getConversationContext().clear();
    }

    public int getConversationContextProcessID() {
        return this.getBiBusHeader().getTracking().getConversationContext().getProcessId();
    }

    public void setConversationContextProcessID(int processID) {
        this.getBiBusHeader().getTracking().getConversationContext().setProcessId(processID);
    }

    public String getCAMAction() {
        String camAction = null;
        Element camElement = this.getOptionalCAM();
        if (camElement == null) {
            return null;
        }
        Element camActionElement = camElement.element("action");
        if (camActionElement == null) {
            return null;
        }
        if (camActionElement.attribute(SOAPEnvelope.XSI_NIL) != null) {
            return null;
        }
        camAction = camActionElement.getText();
        return this.ignoreEmptyCamAction(camAction);
    }

    protected String ignoreEmptyCamAction(String camAction) {
        return StringUtils.isEmpty((String)camAction) ? null : camAction;
    }

    public void setCAMaction(String action) {
        Element camElement = this.getCAM();
        SOAPEnvelope.stripXSINilAttribute(camElement);
        Element eAction = camElement.element("action");
        if (eAction == null) {
            eAction = camElement.addElement("action");
        } else {
            SOAPEnvelope.stripXSINilAttribute(eAction);
        }
        eAction.setText(action);
    }

    public void addSetCookies(Header setCookieHeader) throws HttpException {
        if (setCookieHeader == null) {
            return;
        }
        if (!"Set-Cookie".equalsIgnoreCase(setCookieHeader.getName())) {
            return;
        }
        Cookie[] cookies = MyCookie.parse(setCookieHeader);
        this.addSetCookies(cookies);
    }

    public void addSetCookies(Cookie[] cookies) {
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                this.addSetCookie(cookie);
            }
        }
    }

    public void addSetCookie(Cookie aCookie) {
        if (aCookie == null) {
            return;
        }
        SetCookieVars setCookieVars = this.getBiBusHeader().getHdrSession().getSetCookieVars();
        String cookieName = aCookie.getName();
        String cookieValue = aCookie.getValue();
        int maxAgeValue = 0;
        Date expiryDate = aCookie.getExpiryDate();
        if (expiryDate == null) {
            setCookieVars.setSetCookie(cookieName, cookieValue);
            return;
        }
        long currentTime = System.currentTimeMillis();
        long expiryTime = expiryDate.getTime();
        maxAgeValue = expiryTime <= currentTime ? -1 : (int)(expiryTime - currentTime) / 1000;
        setCookieVars.setSetCookie(cookieName, cookieValue, maxAgeValue);
    }

    public void addSetCookiesServlet(javax.servlet.http.Cookie[] cookies) {
        if (cookies != null) {
            for (javax.servlet.http.Cookie cookie : cookies) {
                this.addSetCookieServlet(cookie);
            }
        }
    }

    public void addSetCookieServlet(javax.servlet.http.Cookie cookie) {
        if (cookie == null) {
            return;
        }
        SetCookieVar setCookie = this.createSetCookie(cookie);
        this.copyCookieAttributes(setCookie, cookie);
        if (log.isDebugEnabled()) {
            this.logSetCookie(setCookie);
        }
    }

    private SetCookieVar createSetCookie(javax.servlet.http.Cookie cookie) {
        SetCookieVars setCookieVars = this.getBiBusHeader().getHdrSession().getSetCookieVars();
        String cookieName = cookie.getName();
        setCookieVars.setSetCookie(cookieName, cookie.getValue(), this.getMaxAgeForSetCookie(cookie));
        return setCookieVars.getSetCookie(cookieName);
    }

    private int getMaxAgeForSetCookie(javax.servlet.http.Cookie cookie) {
        if (this.isMarkedAsDeleted(cookie)) {
            return -1;
        }
        if (this.isSessionCookie(cookie)) {
            return 0;
        }
        return cookie.getMaxAge();
    }

    private boolean isMarkedAsDeleted(javax.servlet.http.Cookie cookie) {
        return cookie.getMaxAge() == 0;
    }

    private boolean isSessionCookie(javax.servlet.http.Cookie cookie) {
        return cookie.getMaxAge() < 0;
    }

    private void copyCookieAttributes(SetCookieVar setCookie, javax.servlet.http.Cookie cookie) {
        this.copySecureFlag(setCookie, cookie);
        this.copyCookieDomain(setCookie, cookie);
        this.copyCookiePath(setCookie, cookie);
    }

    private void copySecureFlag(SetCookieVar setCookie, javax.servlet.http.Cookie cookie) {
        if (cookie.getSecure()) {
            setCookie.setSecure(true);
        }
    }

    private void copyCookieDomain(SetCookieVar setCookie, javax.servlet.http.Cookie cookie) {
        String domain = cookie.getDomain();
        if (StringUtils.isNotEmpty((String)domain)) {
            setCookie.setDomain(domain);
        }
    }

    private void copyCookiePath(SetCookieVar setCookie, javax.servlet.http.Cookie cookie) {
        String path = cookie.getPath();
        if (StringUtils.isNotEmpty((String)path)) {
            setCookie.setPath(path);
        }
    }

    private void logSetCookie(SetCookieVar setCookie) {
        StringBuilder strBuf = new StringBuilder("added setCookie: ");
        strBuf.append("name=").append(setCookie.getName());
        strBuf.append(", value=").append(setCookie.getValue());
        if (setCookie.getPath() != null) {
            strBuf.append(", path=").append(setCookie.getPath());
        }
        strBuf.append(", maxAge=").append(setCookie.getMaxAge());
        if (setCookie.getDomain() != null) {
            strBuf.append(", domain=").append(setCookie.getDomain());
        }
        if (setCookie.getSecure()) {
            strBuf.append(", secure=true");
        }
        log.debug(strBuf.toString());
    }

    public void setCAFSecureState(String value) {
        Element cafElement = this.getCAF();
        SOAPEnvelope.stripXSINilAttribute(cafElement);
        Element secureStateElement = cafElement.element("secureState");
        if (secureStateElement == null) {
            if (value == null) {
                return;
            }
            secureStateElement = cafElement.addElement("secureState");
        } else if (value != null) {
            SOAPEnvelope.stripXSINilAttribute(secureStateElement);
        } else {
            secureStateElement.detach();
            return;
        }
        secureStateElement.setText(value);
    }

    Element getCAF() {
        return this.getMandatoryElement(this.getBIBusHeader(), BUS_CAF);
    }

    public String getCAFSecureState() {
        Element cafElement = this.getOptionalElement(this.getBIBusHeader(), BUS_CAF);
        if (cafElement == null) {
            return null;
        }
        Element secureStateElement = cafElement.element("secureState");
        if (secureStateElement == null) {
            return null;
        }
        if (secureStateElement.attribute(XSI_NIL) != null) {
            return null;
        }
        return secureStateElement.getText();
    }

    public void setRoutingServerGroup(String value) {
        if (value != null) {
            this.getBiBusHeader().getRouting().setRoutingServerGroup(value);
        }
    }

    public String getRoutingServerGroup() {
        return this.getBiBusHeader().getRouting().getRoutingServerGroup();
    }

    @Deprecated
    Element getRouting() {
        return this.getOptionalElement(this.getBIBusHeader(), BUS_ROUTING.getName(), BUS_ROUTING_INFO);
    }

    private BIBusEnvelope(BIBusEnvelope other) {
        super(other);
    }

    public Object clone() throws CloneNotSupportedException {
        BIBusEnvelope newEnv = new BIBusEnvelope(this);
        return newEnv;
    }

    public boolean isFromService(String serviceID) {
        String formValue = this.getFormValue(serviceID);
        if (formValue != null) {
            return formValue.equalsIgnoreCase("true");
        }
        return false;
    }

    public String checkAuthenticated() {
        return this.getPassport().getId();
    }

    public void createCamPassportElement(String passportID) {
        Passport.copyPassportIdToBiBusHeader(this, passportID);
    }

    public void copyPassportIDtoCAM(String passportID) {
        this.getBiBusHeader().getCam().getCAMPassport().setId(passportID);
    }

    public boolean hasCamSettingsElement() {
        return this.getCamSettingsElement() != null;
    }

    private Element getCamSettingsElement() {
        Element cam = this.getOptionalCAM();
        return cam != null ? cam.element(BUS_CAM_SETTINGS.getName()) : null;
    }

    public String getPassportIDFromCookie() {
        String ppid = this.getCookieValue("cam_passport");
        if (ppid == null || ppid.length() == 0) {
            return null;
        }
        return ppid;
    }

    @Deprecated
    public Element getUserCapabilitiesCache() {
        Element biBusHeader = this.getBIBusHeader();
        Element userCapabilitiesCache = this.getMandatoryElement(biBusHeader, BUS_USER_CAPABILITIES_CACHE);
        BIBusEnvelope.stripXSINilAttribute(biBusHeader);
        return userCapabilitiesCache;
    }

    @Deprecated
    public Element getOptionalUserCapabilitiesCache() {
        return this.getOptionalElement(this.getBIBusHeader(), BUS_USER_CAPABILITIES_CACHE);
    }

    public Passport getPassport() {
        if (this.passport == null) {
            this.passport = passportFactory.createPassport(this);
        }
        return this.passport;
    }

    protected PogoLogger getLog() {
        return log;
    }

    public static void setLoggerForTesting(PogoLogger log) {
        BIBusEnvelope.log = log;
    }

    public static void setPassportFactory(PassportFactory passportFactory) {
        BIBusEnvelope.passportFactory = passportFactory;
    }

    public SOAPEnvelope fromDom4j(BIBusEnvelope bridgedEnvelope) throws Exception {
        return bridgedEnvelope;
    }

    public BIBusEnvelope newBIBusEnvelope() {
        return new BIBusEnvelope();
    }

    @Override
    public String toString() {
        try {
            return this.getSafeString();
        }
        catch (IOException e) {
            log.debug("Exception caught while generating XML string: ", e);
            return e.toString();
        }
    }

    public String getSafeString() throws IOException {
        BIBusEnvelope safeEnvelope = new BIBusEnvelope(this);
        SOAPPasswordCleaner.removePassword(safeEnvelope);
        return safeEnvelope.getAsString(PRETTY_PRINT);
    }
}

