/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.HandlerPool;
import com.cognos.pogo.pdk.InvalidServiceException;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.Service;
import com.cognos.pogo.services.attributes.ServiceAttribute;
import com.cognos.pogo.util.DomUtils;
import com.cognos.pogo.util.PogoLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DefaultService
implements Service {
    private static PogoLogger log = PogoLogger.getLogger();
    private static ICCLConfiguration config = CCLConfigurationFactory.createConfiguration();
    protected String serviceName = null;
    private String CMdefaultName = null;
    private boolean registerInCM = false;
    private int loadPriority = 100;
    private int unloadPriority = 100;
    protected List<ServiceAttribute> attrList = new ArrayList<ServiceAttribute>();
    static HashMap<String, String> enabledHash = null;
    private boolean logStartStop = true;
    private boolean forceCMDefaultName = false;
    private boolean suspendable = true;
    private HashMap<String, String> serviceParameters = new HashMap();
    protected ClassLoader classLoader;

    @Override
    public HandlerPool contextualize(Element serviceElement) throws InvalidServiceException {
        String reg;
        this.saveServiceParameters(serviceElement);
        String priority = serviceElement.attributeValue("loadPriority");
        if (priority != null && priority.length() > 0) {
            this.loadPriority = Integer.parseInt(priority);
        }
        if ((reg = serviceElement.attributeValue("registerInCM")) != null && reg.length() > 0) {
            this.registerInCM = Boolean.valueOf(reg);
            this.CMdefaultName = serviceElement.attributeValue("CMdefaultName");
        }
        this.checkForPrerequisites(serviceElement);
        this.loadAttributes(serviceElement);
        return null;
    }

    void saveServiceParameters(Element serviceElement) {
        for (Attribute attribute : serviceElement.attributes()) {
            this.serviceParameters.put(attribute.getName(), attribute.getValue());
        }
    }

    private void checkForPrerequisites(Element serviceElement) throws InvalidServiceException {
        for (Element e : DomUtils.selectNodesFromElement(serviceElement, "prerequisites/prerequisite")) {
            String localProperty;
            String localCMProperty;
            String systemPropertyFail;
            String systemPropertyBool;
            String disabledProperty;
            String className = e.attributeValue("classExists");
            if (className != null && className.length() > 0) {
                this.checkClassExists(className);
                return;
            }
            String fileName = e.attributeValue("fileExists");
            if (fileName != null && fileName.length() > 0) {
                this.checkFileExists(fileName);
            }
            if ((disabledProperty = e.attributeValue("disabledProperty")) != null && disabledProperty.length() > 0) {
                this.checkProperty(disabledProperty);
            }
            if ((systemPropertyBool = e.attributeValue("systemPropertyBool")) != null && systemPropertyBool.length() > 0) {
                this.checkSystemPropertyBool(systemPropertyBool);
            }
            if ((systemPropertyFail = e.attributeValue("systemPropertyFail")) != null && systemPropertyFail.length() > 0) {
                this.checkSystemPropertyFail(systemPropertyFail);
            }
            if ((localCMProperty = e.attributeValue("localCMProperty")) != null && localCMProperty.length() > 0) {
                this.checkLocalCMProperty(localCMProperty);
            }
            if ((localProperty = e.attributeValue("localPropertyFail")) == null || localProperty.length() <= 0) continue;
            this.checkLocalProperty(localProperty);
        }
    }

    private void checkClassExists(String className) throws InvalidServiceException {
        try {
            Class.forName(className).newInstance();
        }
        catch (Exception e) {
            this.registerInCM = false;
            throw new InvalidServiceException();
        }
    }

    private void checkFileExists(String fileName) throws InvalidServiceException {
        String effectivePath = config.resolveEffectivePath(fileName);
        File aFile = new File(effectivePath);
        if (!aFile.exists()) {
            this.registerInCM = false;
            log.warn("Prerequisite file not found: [", fileName, "]. Effective path: [", effectivePath, "]");
            throw new InvalidServiceException();
        }
    }

    private void checkProperty(String disabledProperty) throws InvalidServiceException {
        String disabled = this.getConfigValue(disabledProperty);
        if (disabled.equalsIgnoreCase("false")) {
            this.registerInCM = false;
            throw new InvalidServiceException();
        }
    }

    private void checkSystemPropertyBool(String propName) throws InvalidServiceException {
        if (!Boolean.getBoolean(propName)) {
            log.debug("failed prerequisite on System Bool property ", propName);
            throw new InvalidServiceException();
        }
        log.debug("Satisfied prerequisite that System property is true: ", propName);
    }

    private void checkSystemPropertyFail(String propName) throws InvalidServiceException {
        if (Boolean.getBoolean(propName)) {
            log.warn("failed prerequisite on System Fail property ", propName);
            throw new InvalidServiceException();
        }
        log.debug("Satisfied prerequisite that System property is true: ", propName);
    }

    private void checkLocalCMProperty(String localCMProperty) throws InvalidServiceException {
        for (NodeID cmNode : this.getPossibleCMValues(localCMProperty)) {
            if (!cmNode.isLocalToSelf()) continue;
            return;
        }
        throw new InvalidServiceException();
    }

    private void checkLocalProperty(String localProperty) throws InvalidServiceException {
        String property = PropertyInserter.getProperty(localProperty, "false");
        if (property.equalsIgnoreCase("true")) {
            this.registerInCM = false;
            throw new InvalidServiceException();
        }
    }

    private List<NodeID> getPossibleCMValues(String localCMProperty) {
        return NodeIdGuidMapper.getInstance().getCmUrlList();
    }

    private String getConfigValue(String disabledProperty) {
        String prop;
        if (enabledHash == null) {
            this.getEnabledHashValues();
        }
        if ((prop = enabledHash.get(disabledProperty)) == null) {
            return "false";
        }
        return prop;
    }

    private void getEnabledHashValues() {
        enabledHash = new HashMap();
        try {
            String cbs = config.getValue("CBS", false);
            Document doc = DocumentHelper.parseText((String)cbs);
            Iterator it = doc.getRootElement().elementIterator("parameter");
            while (it.hasNext()) {
                Element e = (Element)it.next();
                String name = e.attributeValue("name");
                String value = e.element("value").getText();
                enabledHash.put(name, value);
            }
        }
        catch (CCLConfigurationException cCLConfigurationException) {
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
    }

    void loadAttributes(Element serviceElement) {
        for (Element attrElem : serviceElement.selectNodes("attributes/attribute")) {
            ServiceAttribute serviceAttribute = new ServiceAttribute(attrElem);
            this.attrList.add(serviceAttribute);
        }
    }

    @Override
    public void compose(PogoEngine h) {
    }

    @Override
    public void configure(Configuration c) {
    }

    @Override
    public void initialize() {
    }

    @Override
    public void start() {
    }

    public void allServicesStarted() {
    }

    @Override
    public void suspend() {
    }

    @Override
    public void suspend(boolean immediate) {
    }

    @Override
    public void resume() {
    }

    @Override
    public void reconfigure(Configuration c) {
    }

    @Override
    public void stop() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getName() {
        return this.serviceName;
    }

    @Override
    public void setName(String name) {
        this.serviceName = name;
    }

    @Override
    public int getLoadPriority() {
        return this.loadPriority;
    }

    @Override
    public void setLoadPriority(int loadPriority) {
        this.loadPriority = loadPriority;
    }

    @Override
    public int getUnloadPriority() {
        if (this.unloadPriority == 100) {
            return this.loadPriority;
        }
        return this.unloadPriority;
    }

    @Override
    public void setUnloadPriority(int unloadPriority) {
        this.unloadPriority = unloadPriority;
    }

    @Override
    public String getCMdefaultName() {
        return this.CMdefaultName;
    }

    @Override
    public boolean isRegisterInCM() {
        return this.registerInCM;
    }

    @Override
    public List<ServiceAttribute> getAttributeList() {
        return this.attrList;
    }

    @Override
    public boolean isLogStartStop() {
        return this.logStartStop;
    }

    @Override
    public void setLogStartStop(boolean value) {
        this.logStartStop = value;
    }

    @Override
    public boolean isForceCMDefaultName() {
        return this.forceCMDefaultName;
    }

    @Override
    public void setForceCMDefaultName(boolean value) {
        this.forceCMDefaultName = value;
    }

    @Override
    public void setSuspendable(boolean value) {
        this.suspendable = value;
    }

    @Override
    public boolean isSuspendable() {
        return this.suspendable;
    }

    public static ICCLConfiguration setConfigForTesting(ICCLConfiguration config) {
        ICCLConfiguration oldConfig = DefaultService.config;
        DefaultService.config = config;
        enabledHash = null;
        return oldConfig;
    }

    @Override
    public String getServiceParameter(String parameterName) {
        return this.serviceParameters.get(parameterName);
    }

    public static void setLoggerForTesting(PogoLogger log) {
        DefaultService.log = log;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    static {
        try {
            config.init();
        }
        catch (CCLConfigurationException cCLConfigurationException) {
            // empty catch block
        }
    }
}

