/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk;

import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.common.BodyFault;
import com.cognos.pogo.pdk.common.BodyFaultException;
import com.cognos.pogo.pdk.common.BodyFaultMessage;
import com.cognos.pogo.pdk.common.EnvelopeFactory;
import com.cognos.pogo.pdk.common.EnvelopeFactorySelector;
import com.cognos.pogo.pdk.util.StackTraceIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;

public class Fault {
    private static final String SERVER_FAULT = "Server";
    private static final String CLIENT_FAULT = "Client";
    private static final String SERVER_FAULT_MSG = "The server did something wrong";
    private static final String CLIENT_FAULT_MSG = "The client did something wrong";
    private static final String NO_MESSAGE_PARAMETERS = "";
    private static final Object[] EMPTY_PARAMETERS = new Object[0];
    private String messageCode;
    private String detailMessasge;
    private Object[] messageParameters;
    private Exception rootCauseException;
    private MessageContext messageContext;
    private Locale locale;
    private List<Handler> traceBack;
    private boolean createdFromSOAPEnvelope;
    private SOAPEnvelope faultEnvelope;
    private BodyFaultException faultException;
    private boolean clientFault;
    private boolean suppressTraceback;
    private int httpStatus = -1;
    private List<String> details;

    public Fault(String messageCode) {
        this.messageCode = messageCode;
    }

    public Fault(String messageCode, Exception rootCauseException) {
        this(messageCode);
        this.rootCauseException = rootCauseException;
    }

    public Fault(String messageCode, SOAPEnvelope faultEnvelope) {
        this(messageCode);
        this.createdFromSOAPEnvelope = true;
        this.faultEnvelope = faultEnvelope;
    }

    public boolean isCreatedFromSOAPEnvelope() {
        return this.createdFromSOAPEnvelope;
    }

    public void setMessageContext(MessageContext messageContext) {
        this.messageContext = messageContext;
        this.traceBack = messageContext.getHandlerTraceBackSnapShot();
        this.locale = (Locale)messageContext.getProperty("locale");
    }

    public Object[] getMessageParameters() {
        return this.messageParameters != null ? this.messageParameters : EMPTY_PARAMETERS;
    }

    public String getMessageCode() {
        return this.messageCode;
    }

    public void setMessageParameters(Object[] params) {
        this.messageParameters = params;
    }

    public SOAPEnvelope generateEnvelope() {
        return this.generateEnvelope(null);
    }

    public SOAPEnvelope generateEnvelope(BIBusEnvelope request) {
        if (this.faultEnvelope != null) {
            this.prepareFaultEnvelopeFor(request);
        } else {
            this.createFaultEnvelopeFor(request);
        }
        return this.faultEnvelope;
    }

    private void prepareFaultEnvelopeFor(BIBusEnvelope request) {
        if (this.needsToCopyRequestHeader()) {
            this.copyRequestHeaderToFaultEnvelope(request);
        }
    }

    private boolean needsToCopyRequestHeader() {
        return !this.isCreatedFromSOAPEnvelope();
    }

    private void copyRequestHeaderToFaultEnvelope(BIBusEnvelope request) {
        if (request != null) {
            request.copyBiBusHeaderTo(this.faultEnvelope);
        }
    }

    private void createFaultEnvelopeFor(BIBusEnvelope request) {
        this.createFaultEnvelopeWithRoundTripHeader(request);
        if (this.hasDetails()) {
            this.addDetails();
        } else if (this.canAddTrace()) {
            this.addTrace();
        }
    }

    private void createFaultEnvelopeWithRoundTripHeader(BIBusEnvelope request) {
        this.createEnvelope(request);
        this.copyRequestHeaderToFaultEnvelope(request);
        this.removeCamProtect();
        this.createFaultException();
    }

    private void createEnvelope(BIBusEnvelope request) {
        EnvelopeFactory envelopeFactory = this.getEnvelopeFactory(request);
        this.faultEnvelope = (SOAPEnvelope)envelopeFactory.createEnvelope(null);
    }

    private EnvelopeFactory getEnvelopeFactory(BIBusEnvelope envelope) {
        return envelope != null ? EnvelopeFactorySelector.getFactoryFor(envelope) : this.getFactoryFromContext();
    }

    private EnvelopeFactory getFactoryFromContext() {
        return EnvelopeFactorySelector.getFactoryFor(this.messageContext);
    }

    private void removeCamProtect() {
        if (this.faultEnvelope instanceof BIBusEnvelope) {
            this.removeCamProtect((BIBusEnvelope)this.faultEnvelope);
        }
    }

    private void removeCamProtect(BIBusEnvelope envelope) {
        envelope.getBiBusHeader().getCamProtect().clear();
    }

    private void createFaultException() {
        BodyFault bodyFault = this.faultEnvelope.getBodyFault();
        bodyFault.setFaultCode(this.clientFault ? CLIENT_FAULT : SERVER_FAULT);
        bodyFault.setFaultString(this.clientFault ? CLIENT_FAULT_MSG : SERVER_FAULT_MSG);
        this.addFaultException(bodyFault);
    }

    private void addFaultException(BodyFault bodyFault) {
        this.faultException = bodyFault.getDetail().createAndAddException();
        this.faultException.setSeverity("error");
        this.faultException.setErrorCode(this.messageCode);
        this.addFaultMessage(this.prepareMessage(this.locale));
    }

    private void addFaultMessage(String message) {
        BodyFaultMessage faultMessage = this.faultException.createAndAddMessage();
        faultMessage.setMessageString(message);
        faultMessage.setNestingLevel(1);
    }

    private boolean hasDetails() {
        return this.details != null && !this.details.isEmpty();
    }

    private void addDetails() {
        StringBuilder sb = new StringBuilder();
        for (String line : this.details) {
            sb.append(line).append("\n");
        }
        this.addFaultMessage(sb.toString());
    }

    private boolean canAddTrace() {
        return !this.isSuppressTraceback();
    }

    private void addTrace() {
        if (this.hasTraceback()) {
            this.addTraceback();
        }
        if (this.rootCauseException != null) {
            this.addRootCauseException();
        }
    }

    private boolean hasTraceback() {
        return this.traceBack != null && !this.traceBack.isEmpty();
    }

    private void addTraceback() {
        StringBuilder sb = new StringBuilder(this.getString("HANDLER_TRACEBACK", this.locale));
        for (Handler handler : this.traceBack) {
            sb.append("\n").append(handler);
        }
        this.addFaultMessage(sb.toString());
    }

    private String getString(String key, Locale locale) {
        return DispatcherStrings.getInstance().getString(key, locale);
    }

    private void addRootCauseException() {
        this.addFaultMessage(this.getString("EXCEPTION_STACKTRACE", this.locale));
        StackTraceIterator it = new StackTraceIterator(this.rootCauseException);
        while (it.hasNext()) {
            this.addFaultMessage((String)it.next());
        }
    }

    public void addDetail(String detailString) {
        if (this.details == null) {
            this.details = new ArrayList<String>();
        }
        this.details.add(detailString);
    }

    public void setClientFault(boolean clientFault) {
        this.clientFault = clientFault;
    }

    public String prepareMessage(Locale locale) {
        return this.detailMessasge != null ? this.detailMessasge : this.getLocalizedString(locale);
    }

    private String getLocalizedString(Locale locale) {
        String resourceMessage = this.getResourceMessage(locale);
        return resourceMessage != null ? resourceMessage : this.prepareLastChanceMessage();
    }

    private String getResourceMessage(Locale locale) {
        try {
            return DispatcherStrings.getInstance().getString(this.getMessageCode(), locale, this.getMessageParameters());
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    public String prepareLastChanceMessage() {
        return this.messageParameters != null ? this.getMessageParametersString() : NO_MESSAGE_PARAMETERS;
    }

    private String getMessageParametersString() {
        StringBuilder sb = new StringBuilder(this.messageCode).append(", \n");
        for (int i = 0; i < this.messageParameters.length; ++i) {
            sb.append(i).append(": \"").append(this.messageParameters[i]).append("\", \n");
        }
        return sb.toString();
    }

    public boolean isSuppressTraceback() {
        return this.suppressTraceback;
    }

    public void setSuppressTraceback(boolean suppressTraceback) {
        this.suppressTraceback = suppressTraceback;
    }

    public void setHTTPStatusOverride(int status) {
        if (status >= 100 && status <= 505) {
            this.httpStatus = status;
        }
    }

    public int getHTTPStatusOverride() {
        return this.httpStatus;
    }

    public void setDetailMessasge(String detailMessasge) {
        this.detailMessasge = detailMessasge;
    }

    public Exception getRootCauseException() {
        return this.rootCauseException;
    }
}

