/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk;

import com.cognos.pogo.pdk.Handler;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class HandlerPool {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(HandlerPool.class.getName());
    private Map<String, Handler> handlers = Collections.synchronizedMap(new LinkedHashMap());

    public void add(String name, Handler handler) {
        if (this.handlers.containsKey(name)) {
            cat.warn("Handler \"" + name + "\" already exists, will use last one defined.");
        }
        this.handlers.put(name, handler);
    }

    public Handler find(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        return this.handlers.get(name);
    }

    public Handler remove(String name) {
        return this.handlers.remove(name);
    }

    public Set<String> keySet() {
        return this.handlers.keySet();
    }

    public Collection<Handler> values() {
        return this.handlers.values();
    }
}

