/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk;

import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends InputStream {
    private int currentPosition = 0;
    private int maxReadLength = Integer.MAX_VALUE;
    private InputStream ins;
    private boolean exceededLimit = false;

    public LimitedInputStream(InputStream ins) {
        this.ins = ins;
    }

    public void setMaxReadLength(int maxMB) {
        this.maxReadLength = maxMB;
    }

    public int getMaxReadLength() {
        return this.maxReadLength;
    }

    @Override
    public int read() throws IOException {
        ++this.currentPosition;
        this.checkPosition();
        return this.ins.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        int ret = this.ins.read(b);
        this.currentPosition += ret;
        this.checkPosition();
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = this.ins.read(b, off, len);
        this.currentPosition += ret;
        this.checkPosition();
        return ret;
    }

    public boolean hasExceededLimit() {
        return this.exceededLimit;
    }

    private void checkPosition() throws IOException {
        if (this.currentPosition > this.maxReadLength) {
            this.exceededLimit = true;
            throw new IOException("ReportServerHandler.LimitedInputStreamError");
        }
    }
}

