/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.common.BodyHandler;
import com.cognos.pogo.pdk.dom4j.Dom4jEnvelopeFactory;
import com.cognos.pogo.pdk.stax.StaxEnvelopeFactory;
import com.cognos.pogo.util.PogoLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import javax.servlet.http.Cookie;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;

public class StringsEnvelope
extends BIBusEnvelope {
    private static PogoLogger log = PogoLogger.getLogger();
    private ArrayList<String> strings;

    public StringsEnvelope(ArrayList<String> strings) {
        super(null, null);
        this.strings = strings;
    }

    @Override
    public void writeAsXML(OutputStream outStream) throws IOException {
        for (String string : this.strings) {
            this.write(outStream, string);
        }
    }

    private void write(OutputStream outStream, String string) throws IOException {
        if (string != null) {
            outStream.write(string.getBytes("UTF-8"));
        }
    }

    @Override
    public void writeAsXML(Writer writer) throws IOException {
        for (String string : this.strings) {
            this.write(writer, string);
        }
    }

    private void write(Writer writer, String string) throws IOException {
        if (string != null) {
            writer.write(string);
        }
    }

    @Override
    public String getAsString(OutputFormat format) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (String string : this.strings) {
            if (string == null) continue;
            sb.append(string);
        }
        return sb.toString();
    }

    public static StringsEnvelope convertToStringsEnvelope(SOAPEnvelope envelope) throws IOException {
        String responseString = envelope.getAsString(SOAPEnvelope.STANDARD_FORMAT);
        ArrayList<String> strings = new ArrayList<String>();
        StringsEnvelope.addResponseString(strings, responseString);
        return new StringsEnvelope(strings);
    }

    private static void addResponseString(ArrayList<String> strings, String responseString) {
        String[] lines;
        for (String line : lines = StringUtils.splitPreserveAllTokens((String)responseString, (String)"\n")) {
            strings.add(line + '\n');
        }
    }

    @Override
    protected Element getMandatoryElement(Element parent, QName elementName, QName dataType) {
        if (!this.isInitialized()) {
            return super.getMandatoryElement(parent, elementName, dataType);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected Element getOptionalElement(Element parent, String elementName, QName dataType) {
        if (!this.isInitialized()) {
            return super.getOptionalElement(parent, elementName, dataType);
        }
        throw new UnsupportedOperationException();
    }

    private boolean isInitialized() {
        return this.strings != null;
    }

    @Override
    public void removeDispatcherTransport(String name) {
    }

    @Override
    public Element getCookieVars() {
        return this.getFakeElement();
    }

    @Override
    public Element getHdrSession() {
        return this.getFakeElement();
    }

    private Element getFakeElement() {
        return (Element)this.getEnvelope().clone();
    }

    @Override
    public Element getSetCookieVars() {
        return null;
    }

    @Override
    public void setCAFSecureState(String value) {
    }

    @Override
    public void addSetCookiesServlet(Cookie[] cookies) {
    }

    @Override
    public Element getCAMProtect() {
        return null;
    }

    @Override
    public SOAPEnvelope toDom4j() throws Exception {
        log.info("Converting StringsEnvelope to Dom4jEnvelope (using strings)");
        return Dom4jEnvelopeFactory.createDom4jEnvelope(this.getAsString());
    }

    @Override
    public SOAPEnvelope toDom4j(InputStream stream) throws Exception {
        if (stream == null) {
            return this.toDom4j();
        }
        log.info("Converting StringsEnvelope to Dom4jEnvelope (using input stream)");
        return Dom4jEnvelopeFactory.createDom4jEnvelope(stream);
    }

    @Override
    public BIBusEnvelope toStax(BodyHandler bodyHandler) throws Exception {
        log.info("Converting StringsEnvelope to StaxEnvelope  (using strings)");
        return StaxEnvelopeFactory.createStaxEnvelope(this.getAsString(), bodyHandler);
    }

    @Override
    public BIBusEnvelope toStax(BodyHandler bodyHandler, InputStream stream) throws Exception {
        if (stream == null) {
            return this.toStax(bodyHandler);
        }
        log.info("Converting dom4j envelope to StaxEnvelope (using input stream)");
        return StaxEnvelopeFactory.createStaxEnvelope(stream, bodyHandler);
    }

    @Override
    public BIBusEnvelope fromDom4j(BIBusEnvelope envelope) throws IOException {
        return StringsEnvelope.convertToStringsEnvelope(envelope);
    }
}

