/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.RequestIDGenerator;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.util.PogoLogger;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class Tracking {
    private static final PogoLogger cat = PogoLogger.getLogger();
    public static final String ID = "id";
    public static final String STATUS = "status";
    public static final String AFFINITY_STRENGTH = "affinityStrength";
    public static final String NODE_ID = "nodeID";
    public static final String TIMESTAMP = "timestamp";
    public static final String PROCESS_ID = "processID";
    private static Tracking instance = null;
    private RequestIDGenerator idGenerator;
    private String requestIDBasename;

    private Tracking(String requestIDBasename) {
        this.idGenerator = new RequestIDGenerator(requestIDBasename);
        this.requestIDBasename = requestIDBasename;
    }

    public static synchronized Tracking getInstance(String baseName) {
        if (instance == null) {
            instance = new Tracking(baseName);
        }
        return instance;
    }

    public static Tracking getInstance() {
        if (instance == null) {
            Tracking.getInstance(Long.toString(System.currentTimeMillis()));
        }
        return instance;
    }

    public String generateRequestContext(String passportid) {
        return this.idGenerator.getNextID(passportid);
    }

    public String generateSessionContext(String tag) {
        return tag + this.getRequestIDBaseName();
    }

    public String getRequestIDBaseName() {
        return this.requestIDBasename;
    }

    public void setRequestIDBasename(String string) {
        this.requestIDBasename = string;
        this.idGenerator.setBasePhrase(string);
    }

    @Deprecated
    public void prepareNew(Element tracking) {
        tracking.addElement(BIBusEnvelope.BUS_REQUEST_CONTEXT.getName()).setText(this.generateRequestContext("none"));
        tracking.addElement(BIBusEnvelope.BUS_STEP_CONTEXT.getName());
        tracking.addElement(BIBusEnvelope.BUS_HOP_COUNT.getName()).setText("0");
        tracking.addElement(BIBusEnvelope.BUS_SESSION_CONTEXT.getName()).setText(Thread.currentThread().getName());
    }

    @Deprecated
    public void setSessionContext(Element tracking, String context) {
        Element sessionContext = tracking.element(BIBusEnvelope.BUS_SESSION_CONTEXT.getName());
        if (sessionContext != null) {
            sessionContext.setText(context);
            SOAPEnvelope.stripXSINilAttribute(sessionContext);
        } else {
            tracking.addElement(BIBusEnvelope.BUS_SESSION_CONTEXT.getName()).setText(context);
        }
    }

    @Deprecated
    public void setRequestContext(Element tracking) {
        this._setRequestContext(tracking, null);
    }

    @Deprecated
    public String prepareRequestContext(Element tracking, boolean preserve) {
        return this.prepareRequestContext(tracking, preserve, "none");
    }

    @Deprecated
    public String prepareRequestContext(Element tracking, boolean preserve, String passportid) {
        if (!preserve) {
            return this._setRequestContext(tracking, passportid);
        }
        return this._setRequestContextPreserve(tracking, passportid);
    }

    @Deprecated
    public String _setRequestContext(Element tracking) {
        return this._setRequestContext(tracking, "none");
    }

    @Deprecated
    public String _setRequestContext(Element tracking, String passportid) {
        Element requestContext = tracking.element(BIBusEnvelope.BUS_REQUEST_CONTEXT.getName());
        String reqID = this.generateRequestContext(passportid);
        if (requestContext != null) {
            requestContext.setText(reqID);
            BIBusEnvelope.stripXSINilAttribute(requestContext);
        } else {
            tracking.addElement(BIBusEnvelope.BUS_REQUEST_CONTEXT.getName()).setText(reqID);
        }
        if (cat.isDebugEnabled()) {
            cat.debug("assigned requestContext: " + reqID);
        }
        return reqID;
    }

    @Deprecated
    public String _setRequestContextPreserve(Element tracking, String passportid) {
        String reqID;
        Element requestContext = tracking.element(BIBusEnvelope.BUS_REQUEST_CONTEXT.getName());
        if (requestContext != null) {
            reqID = requestContext.getTextTrim();
            if (reqID == null || reqID.length() == 0) {
                reqID = this.generateRequestContext(passportid);
                requestContext.setText(reqID);
                BIBusEnvelope.stripXSINilAttribute(requestContext);
                if (cat.isDebugEnabled()) {
                    cat.debug("assigned requestContext: " + reqID);
                }
            } else if (cat.isDebugEnabled()) {
                cat.debug("preserve existing requestContext: " + reqID);
            }
        } else {
            reqID = this.generateRequestContext(passportid);
            tracking.addElement(BIBusEnvelope.BUS_REQUEST_CONTEXT.getName()).setText(reqID);
            if (cat.isDebugEnabled()) {
                cat.debug("assigned requestContext: " + reqID);
            }
        }
        return reqID;
    }

    @Deprecated
    public void incrementHopCount(Element tracking) {
        this._incrementHopCount(tracking);
    }

    @Deprecated
    public long _incrementHopCount(Element tracking) {
        Element hopCountElement = tracking.element(BIBusEnvelope.BUS_HOP_COUNT.getName());
        if (hopCountElement == null) {
            hopCountElement = tracking.addElement(BIBusEnvelope.BUS_HOP_COUNT.getName());
            hopCountElement.setText("0");
            hopCountElement.addAttribute(BIBusEnvelope.XSI_TYPE, BIBusEnvelope.XSD_INTEGER);
            return 0L;
        }
        SOAPEnvelope.stripXSINilAttribute(hopCountElement);
        String count = hopCountElement.getText();
        if (count.equals("0")) {
            hopCountElement.setText("1");
            return 1L;
        }
        long lCount = -1L;
        if (!"".equals(count)) {
            lCount = Long.parseLong(count);
        }
        hopCountElement.setText(Long.toString(++lCount));
        return lCount;
    }

    public String createOrPreserveRequestContext(BIBusEnvelope envelope, String passportid, boolean preserve) {
        if (preserve) {
            return this.createRequestContextIfNotAlreadyPresent(envelope, passportid);
        }
        return this.createRequestContextUnconditionally(envelope, passportid);
    }

    private String createRequestContextIfNotAlreadyPresent(BIBusEnvelope envelope, String passportid) {
        String requestContext = envelope.getRequestContext();
        if (StringUtils.isEmpty((String)requestContext)) {
            requestContext = this.createRequestContextUnconditionally(envelope, passportid);
        } else {
            cat.debug("Preserving existing requestContext: ", requestContext);
        }
        return requestContext;
    }

    private String createRequestContextUnconditionally(BIBusEnvelope envelope, String passportid) {
        String requestContext = this.generateRequestContext(passportid);
        envelope.setRequestContext(requestContext);
        cat.debug("Assigned requestContext: ", requestContext);
        return requestContext;
    }

    public void setRequestIDGeneratorForTesting(RequestIDGenerator requestIDGenerator) {
        this.idGenerator = requestIDGenerator;
    }
}

