/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.dom4j;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.common.EnvelopeElement;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.XmlUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.QName;

public abstract class Dom4jBase
implements EnvelopeElement {
    protected static final PogoLogger log = PogoLogger.getLogger();

    public static void setChildElementText(Element parent, String name, String value) {
        Dom4jBase.setChildElementText(parent, name, null, value);
    }

    public static void setChildElementText(Element parent, String name, String type, String value) {
        Element child = Dom4jBase.getOrCreateChildElement(parent, name, type);
        child.setText(value);
    }

    public static Element getOrCreateChildElement(Element parent, String name, String type) {
        Element child = parent.element(name);
        if (child == null) {
            child = Dom4jBase.createAndAddElement(parent, name, type);
        }
        BIBusEnvelope.stripXSINilAttribute(child);
        return child;
    }

    public static Element getOrCreateChildElement(Element parent, QName name, QName type) {
        return Dom4jBase.getOrCreateChildElement(parent, name.getName(), type.getQualifiedName());
    }

    private static Element createAndAddElement(Element parent, String name, String type) {
        Element child = parent.addElement(name);
        Dom4jBase.maybeAddType(child, type);
        BIBusEnvelope.stripXSINilAttribute(parent);
        return child;
    }

    private static void maybeAddType(Element child, String type) {
        if (type != null) {
            child.addAttribute(BIBusEnvelope.XSI_TYPE, type);
        }
    }

    public void removeChildElement(Element parent, String name) {
        Element childElement;
        Element element = childElement = parent != null ? parent.element(name) : null;
        if (childElement != null) {
            childElement.detach();
        }
    }

    public String getChildElementText(Element parent, String childName) {
        Element child = this.getChildElement(parent, childName);
        return Dom4jBase.isNil(child) ? null : child.getText();
    }

    public Element getChildElement(Element parent, String childName) {
        return Dom4jBase.isNil(parent) ? null : parent.element(childName);
    }

    public static int parseInt(String name, String value, int defaultValue) {
        if (StringUtils.isEmpty((String)value)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            Dom4jBase.logException(name, value, e);
            return defaultValue;
        }
    }

    private static void logException(String name, String value, NumberFormatException e) {
        log.debug("Invalid " + name + " text format: " + value, e);
    }

    public static long parseLong(String name, String value, long defaultValue) {
        if (StringUtils.isEmpty((String)value)) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            Dom4jBase.logException(name, value, e);
            return defaultValue;
        }
    }

    protected void clear(Element element) {
        if (element.attribute(SOAPEnvelope.XSI_NIL) == null) {
            element.clearContent();
            element.addAttribute(SOAPEnvelope.XSI_NIL, "true");
        }
    }

    public static boolean isNil(Element element) {
        return element == null || Dom4jBase.isXsiNil(element);
    }

    public static boolean isXsiNil(Element element) {
        Attribute xsiNil = element != null ? element.attribute(SOAPEnvelope.XSI_NIL) : null;
        return xsiNil != null && Boolean.parseBoolean(xsiNil.getValue());
    }

    public String toString() {
        String asXML = this.asXML();
        return asXML != null ? XmlUtils.prettyPrintAndCatchException(asXML) : "null";
    }
}

