/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.dom4j;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.common.UserCapabilityCache;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class Dom4jUserCapabilityCache
extends UserCapabilityCache {
    private static final String USER_CAPABILITIES = "userCapabilities";
    private static final String BUS_USER_CAPABILITY_ENUM = "bus:userCapabilityEnum";
    private static final String ITEM = "item";
    private static final String SIGNATURE = "signature";
    private final BIBusEnvelope biBusEnvelope;

    public Dom4jUserCapabilityCache(BIBusEnvelope biBusEnvelope) {
        this.biBusEnvelope = biBusEnvelope;
    }

    @Override
    public boolean isPresent() {
        return this.biBusEnvelope.getOptionalUserCapabilitiesCache() != null;
    }

    @Override
    public boolean isEmpty() {
        Element userCapabilitiesCache = this.biBusEnvelope.getOptionalUserCapabilitiesCache();
        return userCapabilitiesCache == null || !userCapabilitiesCache.hasContent();
    }

    @Override
    protected void storeDecodedValues(List<String> capabilities, String signature) {
        this.createUserCapabilitiesElement();
        super.storeDecodedValues(capabilities, signature);
    }

    private void createUserCapabilitiesElement() {
        Element userCapabilitiesCache = this.biBusEnvelope.getUserCapabilitiesCache();
        Element userCapabilities = userCapabilitiesCache.addElement(USER_CAPABILITIES);
        userCapabilities.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        userCapabilities.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, "bus:userCapabilityEnum[]");
    }

    @Override
    public void addCapabilities(List<String> capabilities) {
        Element userCapabilities = this.getUserCapabilities();
        for (String item : capabilities) {
            this.addItem(userCapabilities, item);
        }
    }

    private Element getUserCapabilities() {
        Element userCapabilitiesCache = this.biBusEnvelope.getUserCapabilitiesCache();
        return userCapabilitiesCache != null ? userCapabilitiesCache.element(USER_CAPABILITIES) : null;
    }

    private void addItem(Element userCapabilities, String item) {
        Element itemElement = userCapabilities.addElement(ITEM);
        itemElement.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_USER_CAPABILITY_ENUM);
        itemElement.addText(item);
    }

    @Override
    public void addSignature(String signature) {
        Element userCapabilitiesCache = this.biBusEnvelope.getUserCapabilitiesCache();
        Element signatureElement = userCapabilitiesCache.addElement(SIGNATURE);
        signatureElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_BASE64BINARY);
        signatureElement.addText(signature);
    }

    @Override
    public String asXML() {
        return this.biBusEnvelope.getUserCapabilitiesCache().asXML();
    }

    @Override
    public int getNrOfItems() {
        Element userCapabilities = this.getUserCapabilities();
        return userCapabilities != null ? userCapabilities.nodeCount() : 0;
    }

    @Override
    public boolean hasItem(String item) {
        for (Element element : this.getUserCapabilitiesCacheElements()) {
            if (!StringUtils.equals((String)element.getText(), (String)item)) continue;
            return true;
        }
        return false;
    }

    private List<Element> getUserCapabilitiesCacheElements() {
        return this.isEmpty() ? Collections.emptyList() : this.getUserCapabilities().elements();
    }

    @Override
    public String getSignature() {
        Element userCapabilitiesCache = this.biBusEnvelope.getUserCapabilitiesCache();
        Element signatureElement = userCapabilitiesCache != null ? userCapabilitiesCache.element(SIGNATURE) : null;
        return signatureElement != null ? signatureElement.getText() : null;
    }
}

