/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.soapaction;

import com.cognos.p2plb.clerver.balancer.OMBridgeHelper;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.soapaction.SoapActionLookup;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.internal.ombridge.BibusSoapAction;
import java.util.List;

public class BridgeRequestHandler
extends BasicHandler {
    private static final PogoLogger log = PogoLogger.getLogger();
    protected OMBridgeHelper omBridgeHelper;
    protected String currentVersion;
    protected String oldestVersion;
    protected boolean explicitBridging;

    public BridgeRequestHandler() {
        this(new OMBridgeHelper());
    }

    public BridgeRequestHandler(OMBridgeHelper omBridgeHelper) {
        super(log.getNativeLogger());
        this.omBridgeHelper = omBridgeHelper;
        List<String> supportedVersions = omBridgeHelper.getSupportedVersions();
        this.currentVersion = supportedVersions.get(0);
        this.oldestVersion = supportedVersions.get(supportedVersions.size() - 1);
        this.explicitBridging = !SoapActionLookup.enableAutomaticBridging();
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        String sourceVersion;
        if (this.explicitBridging && (sourceVersion = this.getSourceVersion(mc)) != null) {
            this.doBridging(mc, sourceVersion);
        }
    }

    protected void doBridging(MessageContext mc, String sourceVersion) {
        this.omBridgeHelper.bridgeRequest(mc, sourceVersion, this.currentVersion);
    }

    private String getSourceVersion(MessageContext mc) {
        String soapaction = mc.getStrProperty("request.soapaction");
        BibusSoapAction bibusSoapAction = new BibusSoapAction(soapaction);
        if (bibusSoapAction.getFormat() == BibusSoapAction.Format.Unknown) {
            return null;
        }
        if (bibusSoapAction.getFormat() != BibusSoapAction.Format.IBM) {
            return this.oldestVersion;
        }
        return bibusSoapAction.getVersion();
    }
}

