/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.stax;

import com.cognos.pogo.pdk.common.BiBusHeader;
import com.cognos.pogo.pdk.common.Caf;
import com.cognos.pogo.pdk.stax.StaxCaf;
import com.cognos.pogo.pdk.stax.StaxDispatcherTransportVars;
import com.cognos.pogo.pdk.stax.StaxHdrSession;
import com.cognos.pogo.pdk.stax.StaxRouting;
import com.cognos.pogo.pdk.stax.StaxTracking;
import com.cognos.pogo.pdk.stax.StaxUserCapabilityCache;
import com.cognos.pogo.pdk.stax.StaxUserPreferenceVars;
import com.cognos.pogo.pdk.stax.cam.StaxCam;
import com.cognos.pogo.pdk.stax.cam.StaxCamProtect;
import com.cognos.pogo.stax.utils.StaxBase;
import com.cognos.pogo.stax.utils.StaxElement;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StaxBiBusHeader
extends StaxBase
implements BiBusHeader {
    private static final String BI_BUS_HEADER = "biBusHeader";
    private static final String BI_BUS_HEADER_NAMESPACE = "http://developer.cognos.com/schemas/bibus/3/";
    private final StaxUserCapabilityCache userCapabilityCache;
    private final StaxDispatcherTransportVars dispatcherTransportVars;
    private final StaxUserPreferenceVars userPreferenceVars;
    private final StaxHdrSession hdrSession;
    private final StaxCam cam;
    private final StaxCamProtect camProtect;
    private final StaxCaf caf;
    private final StaxTracking tracking;
    private final StaxRouting routing;
    private StaxElement[] staxElements;

    public StaxBiBusHeader() {
        this.userCapabilityCache = new StaxUserCapabilityCache();
        this.dispatcherTransportVars = new StaxDispatcherTransportVars();
        this.userPreferenceVars = new StaxUserPreferenceVars();
        this.hdrSession = new StaxHdrSession();
        this.cam = new StaxCam();
        this.camProtect = new StaxCamProtect();
        this.caf = new StaxCaf();
        this.tracking = new StaxTracking();
        this.routing = new StaxRouting();
        this.setStaxElements();
    }

    private void setStaxElements() {
        this.staxElements = new StaxElement[]{this.userCapabilityCache, this.dispatcherTransportVars, this.userPreferenceVars, this.hdrSession, this.cam, this.camProtect, this.caf, this.tracking, this.routing};
    }

    public StaxBiBusHeader(StaxBiBusHeader staxBiBusHeader) {
        this.userCapabilityCache = new StaxUserCapabilityCache(staxBiBusHeader.userCapabilityCache);
        this.dispatcherTransportVars = new StaxDispatcherTransportVars(staxBiBusHeader.dispatcherTransportVars);
        this.userPreferenceVars = new StaxUserPreferenceVars(staxBiBusHeader.userPreferenceVars);
        this.hdrSession = new StaxHdrSession(staxBiBusHeader.hdrSession);
        this.cam = new StaxCam(staxBiBusHeader.cam);
        this.camProtect = new StaxCamProtect(staxBiBusHeader.camProtect);
        this.caf = new StaxCaf(staxBiBusHeader.caf);
        this.tracking = new StaxTracking(staxBiBusHeader.tracking);
        this.routing = new StaxRouting(staxBiBusHeader.routing);
        this.setStaxElements();
    }

    @Override
    public StaxUserCapabilityCache getUserCapabilityCache() {
        return this.userCapabilityCache;
    }

    @Override
    public StaxDispatcherTransportVars getDispatcherTransportVars() {
        return this.dispatcherTransportVars;
    }

    @Override
    public StaxUserPreferenceVars getUserPreferenceVars() {
        return this.userPreferenceVars;
    }

    @Override
    public StaxHdrSession getHdrSession() {
        return this.hdrSession;
    }

    @Override
    public StaxCam getCam() {
        return this.cam;
    }

    @Override
    public StaxCamProtect getCamProtect() {
        return this.camProtect;
    }

    @Override
    public Caf getCaf() {
        return this.caf;
    }

    @Override
    public StaxTracking getTracking() {
        return this.tracking;
    }

    @Override
    public StaxRouting getRouting() {
        return this.routing;
    }

    @Override
    public boolean canParse(String entryName) {
        return BI_BUS_HEADER.equals(entryName);
    }

    @Override
    protected void parseElement(XMLStreamReader xsr, String entryName) throws XMLStreamException {
        for (StaxElement element : this.staxElements) {
            if (!element.canParse(entryName)) continue;
            element.parse(xsr, entryName);
            break;
        }
    }

    @Override
    public void writeXML(XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        xsw.writeStartElement("", BI_BUS_HEADER, BI_BUS_HEADER_NAMESPACE);
        xsw.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", "bus:biBusHeader");
        this.writeStaxElements(xsw);
        xsw.writeEndElement();
        xsw.flush();
    }

    private void writeStaxElements(XMLStreamWriter xsw) throws XMLStreamException {
        for (StaxElement element : this.staxElements) {
            StaxBiBusHeader.writeChildXML(element, xsw);
        }
    }

    @Override
    public boolean isEmpty() {
        for (StaxElement element : this.staxElements) {
            if (element.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPresent() {
        for (StaxElement element : this.staxElements) {
            if (!element.isPresent()) continue;
            return true;
        }
        return false;
    }
}

