/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.stax;

import com.cognos.pogo.pdk.common.BodyFaultException;
import com.cognos.pogo.pdk.common.BodyFaultMessage;
import com.cognos.pogo.pdk.stax.StaxBodyFaultMessage;
import com.cognos.pogo.stax.utils.StaxBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StaxBodyFaultException
extends StaxBase
implements BodyFaultException {
    private List<BodyFaultMessage> messages = new ArrayList<BodyFaultMessage>();
    private String severity;
    private String errorCode;

    public StaxBodyFaultException(XMLStreamReader xsr, String entryName) throws XMLStreamException {
        this.parse(xsr, entryName);
    }

    public StaxBodyFaultException() {
    }

    public StaxBodyFaultException(BodyFaultException source) {
        for (BodyFaultMessage message : source.getMessages()) {
            this.messages.add(new StaxBodyFaultMessage(message));
        }
        this.setSeverity(source.getSeverity());
        this.setErrorCode(source.getErrorCode());
    }

    @Override
    public boolean canParse(String entryName) {
        return "exception".equals(entryName);
    }

    @Override
    protected void parseElement(XMLStreamReader xsr, String localName) throws XMLStreamException {
        if (localName.equals("message")) {
            this.messages.add(new StaxBodyFaultMessage(xsr, localName));
        } else if (localName.equals("severity")) {
            this.severity = xsr.getElementText();
        } else if (localName.equals("errorCode")) {
            this.errorCode = xsr.getElementText();
        }
    }

    @Override
    public void writeXML(XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        StaxBodyFaultException.writeStartServiceElement("exception", "bus", "http://developer.cognos.com/schemas/bibus/3/", xsw);
        StaxBodyFaultException.writeElement("severity", this.severity, xsw);
        StaxBodyFaultException.writeElement("errorCode", this.errorCode, xsw);
        for (BodyFaultMessage message : this.messages) {
            StaxBodyFaultException.writeChildXML((StaxBodyFaultMessage)message, xsw);
        }
        xsw.writeEndElement();
    }

    @Override
    public boolean isPresent() {
        return !this.messages.isEmpty() || this.errorCode != null || this.severity != null;
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public String getSeverity() {
        return this.severity;
    }

    @Override
    public void setSeverity(String severity) {
        this.severity = severity;
    }

    @Override
    public List<BodyFaultMessage> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    @Override
    public StaxBodyFaultMessage createAndAddMessage() {
        StaxBodyFaultMessage message = new StaxBodyFaultMessage();
        this.messages.add(message);
        return message;
    }

    @Override
    public void clearMessages() {
        this.messages.clear();
    }
}

