/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.stax;

import com.cognos.pogo.pdk.common.UserCapabilityCache;
import com.cognos.pogo.pdk.stax.StaxUserCapabilities;
import com.cognos.pogo.stax.utils.StaxBase;
import com.cognos.pogo.stax.utils.StaxElement;
import com.cognos.pogo.stax.utils.StaxUtils;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StaxUserCapabilityCache
extends UserCapabilityCache
implements StaxElement {
    public static final String USER_CAPABILITY_CACHE = "userCapabilityCache";
    public static final String SIGNATURE = "signature";
    private String signature;
    private StaxUserCapabilities items;

    public StaxUserCapabilityCache() {
        this.items = new StaxUserCapabilities();
    }

    public StaxUserCapabilityCache(StaxUserCapabilityCache source) {
        this.signature = source.signature;
        this.items = new StaxUserCapabilities(source.items);
    }

    @Override
    public void addCapabilities(List<String> capabilities) {
        for (String item : capabilities) {
            this.items.add(item);
        }
    }

    @Override
    public void addSignature(String signature) {
        this.signature = signature;
    }

    @Override
    public String asXML() {
        return StaxBase.toString(this);
    }

    @Override
    public int getNrOfItems() {
        return this.items.size();
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public boolean hasItem(String item) {
        return this.items.hasItem(item);
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public boolean isPresent() {
        return this.signature != null || this.items.isPresent();
    }

    @Override
    public boolean canParse(String entryName) {
        return USER_CAPABILITY_CACHE.equals(entryName);
    }

    @Override
    public void parse(XMLStreamReader xsr, String entryName) throws XMLStreamException {
        while (StaxUtils.moveToNextElementWithinParent(entryName, xsr)) {
            this.parseElement(xsr, xsr.getLocalName());
        }
    }

    private void parseElement(XMLStreamReader xsr, String localName) throws XMLStreamException {
        if (SIGNATURE.equals(localName)) {
            this.signature = xsr.getElementText();
        } else if (this.items.canParse(localName)) {
            this.items.parse(xsr, localName);
        }
    }

    @Override
    public void writeXML(XMLStreamWriter xsw) throws XMLStreamException {
        this.writeXML(xsw, true);
    }

    @Override
    public void writeXML(XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        StaxBase.writeStartBusElement(USER_CAPABILITY_CACHE, USER_CAPABILITY_CACHE, writeNamespace, xsw);
        StaxBase.writeBase64BinaryElement(SIGNATURE, this.signature, xsw);
        this.items.writeXML(xsw, writeNamespace);
        xsw.writeEndElement();
        xsw.flush();
    }
}

