/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.stax.cam;

import com.cognos.pogo.pdk.common.CAMPassport;
import com.cognos.pogo.stax.utils.StaxBase;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;

public class StaxCAMPassport
extends StaxBase
implements CAMPassport {
    public static final StaxCAMPassport NULL = new StaxCAMPassport();
    private Integer generation;
    private String id;
    private Boolean isAnonymous;
    private Boolean isLogEnabled;
    private Boolean canCallLogon;
    private Boolean isShareable;
    private boolean wasParsed;

    public StaxCAMPassport() {
    }

    public StaxCAMPassport(XMLStreamReader xsr) throws XMLStreamException {
        this.parse(xsr, "CAMPassport");
    }

    public StaxCAMPassport(StaxCAMPassport source) {
        this.generation = source.generation;
        this.id = source.id;
        this.isAnonymous = source.isAnonymous;
        this.isLogEnabled = source.isLogEnabled;
        this.canCallLogon = source.canCallLogon;
        this.isShareable = source.isShareable;
        this.wasParsed = source.wasParsed;
    }

    @Override
    public boolean canParse(String entryName) {
        return "CAMPassport".equals(entryName);
    }

    @Override
    public void parse(XMLStreamReader xsr, String entryName) throws XMLStreamException {
        super.parse(xsr, entryName);
        this.wasParsed = true;
    }

    @Override
    protected void parseElement(XMLStreamReader xsr, String localName) throws XMLStreamException {
        if ("canCallLogon".equals(localName)) {
            this.canCallLogon = StaxCAMPassport.parseBoolean(xsr);
        } else if ("generation".equals(localName)) {
            this.generation = StaxCAMPassport.parseInteger(xsr);
        } else if ("id".equals(localName)) {
            this.id = xsr.getElementText();
        } else if ("isAnonymous".equals(localName)) {
            this.isAnonymous = StaxCAMPassport.parseBoolean(xsr);
        } else if ("logEnabled".equals(localName)) {
            this.isLogEnabled = this.parseLogEnabled(xsr);
        } else if ("shareable".equals(localName)) {
            this.isShareable = StaxCAMPassport.parseBoolean(xsr);
        }
    }

    private Boolean parseLogEnabled(XMLStreamReader xsr) throws XMLStreamException {
        String logEnabledText = xsr.getElementText();
        return StringUtils.isEmpty((String)logEnabledText) ? true : Boolean.valueOf(logEnabledText);
    }

    @Override
    public boolean isPresent() {
        return this.wasParsed || !this.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return this.id == null && this.isAnonymous == null && this.isLogEnabled == null && this.canCallLogon == null && this.isShareable == null;
    }

    @Override
    public boolean canCallLogon() {
        return this.canCallLogon != null ? this.canCallLogon : false;
    }

    @Override
    public int getGeneration() {
        return this.generation != null ? this.generation : 0;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isAnonymous() {
        return this.isAnonymous != null ? this.isAnonymous : false;
    }

    @Override
    public boolean isLogEnabled() {
        return this.isPresent() ? this.getLogEnabledElementValue() : true;
    }

    private boolean getLogEnabledElementValue() {
        return this.isLogEnabled != null ? this.isLogEnabled : false;
    }

    @Override
    public boolean isShareable() {
        return this.isShareable != null ? this.isShareable : false;
    }

    @Override
    public void writeXML(XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        StaxCAMPassport.writeStartBusElement("CAMPassport", "CAMPassport", writeNamespace, xsw);
        StaxCAMPassport.writeBooleanElement("canCallLogon", this.canCallLogon, xsw);
        StaxCAMPassport.writeIntElement("generation", this.generation, xsw);
        StaxCAMPassport.writeStringElement("id", this.id, xsw);
        StaxCAMPassport.writeBooleanElement("logEnabled", this.isLogEnabled, xsw);
        StaxCAMPassport.writeBooleanElement("isAnonymous", this.isAnonymous, xsw);
        StaxCAMPassport.writeBooleanElement("shareable", this.isShareable, xsw);
        xsw.writeEndElement();
    }

    @Override
    public void setCanCallLogon(Boolean canCallLogon) {
        this.canCallLogon = canCallLogon;
    }

    @Override
    public void setGeneration(Integer generation) {
        this.generation = generation;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setLogEnabled(Boolean isLogEnabled) {
        this.isLogEnabled = isLogEnabled;
    }

    @Override
    public void setAnonymous(Boolean isAnonymous) {
        this.isAnonymous = isAnonymous;
    }

    @Override
    public void setShareable(Boolean isShareable) {
        this.isShareable = isShareable;
    }
}

