/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.stax.cam;

import com.cognos.pogo.pdk.stax.cam.StaxPromptOptions;
import com.cognos.pogo.stax.utils.StaxMapEntry;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StaxDisplayObjectsEntry
extends StaxMapEntry {
    private static final String CAPTION = "caption";
    private static final String TYPE = "type";
    private String name;
    private String type;
    private String value;
    private String caption;
    private StaxPromptOptions promptOptions = StaxPromptOptions.NULL;

    public StaxDisplayObjectsEntry() {
    }

    public StaxDisplayObjectsEntry(StaxDisplayObjectsEntry source) {
        this.name = source.name;
        this.type = source.type;
        this.value = source.value;
        this.caption = source.caption;
        this.promptOptions = source.promptOptions.isEmpty() ? StaxPromptOptions.NULL : new StaxPromptOptions(source.promptOptions);
    }

    @Override
    public boolean canParse(String entryName) {
        return true;
    }

    @Override
    protected void parseElement(XMLStreamReader xsr, String localName) throws XMLStreamException {
        if ("name".equals(localName)) {
            this.name = xsr.getElementText();
        } else if (TYPE.equals(localName)) {
            this.type = xsr.getElementText();
        } else if ("value".equals(localName)) {
            this.value = xsr.getElementText();
        } else if (CAPTION.equals(localName)) {
            this.caption = xsr.getElementText();
        } else if (this.promptOptions.canParse(localName)) {
            this.promptOptions = new StaxPromptOptions(xsr);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void writeXML(XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        StaxDisplayObjectsEntry.writeStringElement(CAPTION, this.caption, xsw);
        StaxDisplayObjectsEntry.writeChildXML(this.promptOptions, xsw);
        StaxDisplayObjectsEntry.writeStringElement(TYPE, this.type, xsw);
        StaxDisplayObjectsEntry.writeStringElement("value", this.value, xsw);
    }

    @Override
    public boolean isPresent() {
        return false;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public StaxPromptOptions getPromptOptions() {
        return this.promptOptions;
    }
}

