/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.stax.cam;

import com.cognos.pogo.stax.utils.StaxBase;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StaxMessage
extends StaxBase {
    private static final String NESTING_LEVEL = "nestingLevel";
    private static final String MESSAGE_STRING = "messageString";
    private Integer nestingLevel;
    private String messageString;

    public StaxMessage() {
    }

    public StaxMessage(XMLStreamReader xsr, String entryName) throws XMLStreamException {
        this.parse(xsr, entryName);
    }

    public StaxMessage(StaxMessage source) {
        this.nestingLevel = source.nestingLevel;
        this.messageString = source.messageString;
    }

    public String getMessageString() {
        return this.messageString;
    }

    public Integer getNestingLevel() {
        return this.nestingLevel;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public boolean canParse(String entryName) {
        return true;
    }

    @Override
    protected void parseElement(XMLStreamReader xsr, String localName) throws XMLStreamException {
        if (MESSAGE_STRING.equals(localName)) {
            this.messageString = xsr.getElementText();
        } else if (NESTING_LEVEL.equals(localName)) {
            this.nestingLevel = StaxMessage.parseInteger(xsr);
        }
    }

    @Override
    public void writeXML(XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        StaxMessage.writeIntElement(NESTING_LEVEL, this.nestingLevel, xsw);
        StaxMessage.writeStringElement(MESSAGE_STRING, this.messageString, xsw);
    }
}

