/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.stax.cam;

import com.cognos.pogo.stax.utils.StaxBase;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StaxSettings
extends StaxBase {
    public static final StaxSettings NULL = new StaxSettings();
    private static final String SETTINGS = "settings";
    private static final String CAMSETTINGS = "CAMSettings";
    private static final String NAMESPACES_CONFIGURED = "namespacesConfigured";
    private static final String ANONYMOUS_ALLOWED = "anonymousAllowed";
    private Boolean anonymousAllowed;
    private Boolean namespacesConfigured;

    public StaxSettings(XMLStreamReader xsr) throws XMLStreamException {
        this.parse(xsr, SETTINGS);
    }

    public StaxSettings() {
    }

    public StaxSettings(StaxSettings source) {
        this.anonymousAllowed = source.anonymousAllowed;
        this.namespacesConfigured = source.namespacesConfigured;
    }

    @Override
    public boolean canParse(String entryName) {
        return SETTINGS.equals(entryName);
    }

    @Override
    protected void parseElement(XMLStreamReader xsr, String localName) throws XMLStreamException {
        if (ANONYMOUS_ALLOWED.equals(localName)) {
            this.anonymousAllowed = StaxSettings.parseBoolean(xsr);
        } else if (NAMESPACES_CONFIGURED.equals(localName)) {
            this.namespacesConfigured = StaxSettings.parseBoolean(xsr);
        }
    }

    @Override
    public boolean isPresent() {
        return this.anonymousAllowed != null && this.namespacesConfigured != null;
    }

    public boolean anonymousAllowed() {
        return this.anonymousAllowed;
    }

    public boolean namespacesConfigured() {
        return this.namespacesConfigured;
    }

    @Override
    public void writeXML(XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        StaxSettings.writeStartBusElement(SETTINGS, CAMSETTINGS, writeNamespace, xsw);
        StaxSettings.writeBooleanElement(ANONYMOUS_ALLOWED, this.anonymousAllowed, xsw);
        StaxSettings.writeBooleanElement(NAMESPACES_CONFIGURED, this.namespacesConfigured, xsw);
        xsw.writeEndElement();
    }

    public void setAnonymousAllowed(boolean anonymousAllowed) {
        this.anonymousAllowed = anonymousAllowed;
    }

    public void setNamespacesConfigured(boolean namespacesConfigured) {
        this.namespacesConfigured = namespacesConfigured;
    }
}

