/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.xml;

import com.cognos.pogo.pdk.xml.PooledSAXReader;
import com.cognos.pogo.pdk.xml.SoftPooledSAXReader;
import com.cognos.pogo.pdk.xml.StickyPooledSAXReader;
import com.cognos.pogo.pdk.xml.UnPooledSAXReader;
import com.cognos.pogo.util.PogoLogger;
import java.util.ArrayList;
import org.apache.log.Priority;
import org.dom4j.io.SAXReader;

public class SAXReaderPool {
    private static final PogoLogger logger = PogoLogger.getLogger();
    static SAXReaderPool instance = null;
    boolean poolingEnabled;
    private ArrayList<PooledSAXReader> freeList = new ArrayList();
    private int maxSticky;
    private int stickyCount = 0;
    boolean resetOnRelease;
    private int maxPoolSize = 0;

    public static synchronized void prepare(boolean poolingEnabled, int numberOfStickyParsers) {
        if (instance == null) {
            instance = new SAXReaderPool(poolingEnabled, numberOfStickyParsers);
        }
    }

    public static SAXReaderPool getInstance() {
        if (instance == null) {
            SAXReaderPool.createSAXReaderPoolForUnitTest();
        }
        return instance;
    }

    protected SAXReaderPool(boolean poolingEnabled, int numberOfStickyParsers) {
        this.poolingEnabled = poolingEnabled;
        this.maxSticky = numberOfStickyParsers;
    }

    public int getMaxSize() {
        return this.maxPoolSize;
    }

    public void resetMaxSize() {
        this.maxPoolSize = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        ArrayList<PooledSAXReader> arrayList = this.freeList;
        synchronized (arrayList) {
            return this.freeList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledSAXReader get() {
        if (!this.poolingEnabled) {
            return new UnPooledSAXReader(new SAXReader(), this);
        }
        PooledSAXReader pooledReader = null;
        boolean createSticky = false;
        ArrayList<PooledSAXReader> arrayList = this.freeList;
        synchronized (arrayList) {
            while (!this.freeList.isEmpty()) {
                pooledReader = this.freeList.remove(this.freeList.size() - 1);
                if (!pooledReader.isValid()) continue;
                logger.debug("got valid pooled SAX reader from pool");
                pooledReader.disallowDocType();
                return pooledReader;
            }
            if (this.stickyCount < this.maxSticky) {
                ++this.stickyCount;
                createSticky = true;
            }
        }
        if (createSticky) {
            logger.info("created new sticky pooled SAXReader.");
            return new StickyPooledSAXReader(new SAXReader(), this);
        }
        logger.info("created brand new soft pooled SAXReader.");
        return new SoftPooledSAXReader(new SAXReader(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release(PooledSAXReader pooledReader) {
        this.resetPooledReader(pooledReader);
        ArrayList<PooledSAXReader> arrayList = this.freeList;
        synchronized (arrayList) {
            this.freeList.add(pooledReader);
            if (this.freeList.size() > this.maxPoolSize) {
                this.maxPoolSize = this.freeList.size();
            }
        }
    }

    private void resetPooledReader(PooledSAXReader pooledReader) {
        if (this.resetOnRelease) {
            pooledReader.reset();
        }
    }

    private static void createSAXReaderPoolForUnitTest() {
        if (instance == null) {
            instance = new SAXReaderPool(true, 10);
        }
    }

    public static void setLogPriority(Priority priority) {
        logger.setPriority(priority);
    }

    public synchronized void setResetOnRelease(boolean resetOnRelease) {
        logger.debug("Reset on release set to ", resetOnRelease);
        this.resetOnRelease = resetOnRelease;
    }

    static void resetForTesting() {
        instance = null;
    }
}

