/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice;

import com.cognos.pogo.capacity.ServiceCapacityConfiguration;
import com.cognos.pogo.capacity.ServiceCapacityMediator;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.reportservice.ReportServerHandler;
import java.text.ParseException;
import java.util.Date;
import java.util.Timer;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class BatchReportServerHandler
extends ReportServerHandler {
    private static final Logger category = Hierarchy.getDefaultHierarchy().getLoggerFor(BatchReportServerHandler.class.getName());
    private static final String BATCH_PROCESS_USE_LIMIT = "DISP.BatchProcessUseLimit";
    private static final String REPORT_SERVER_MODE_BATCH = "Batch";
    private static final String BATCH_REPORT_SERVICE = "batchReportService";
    private static final String MONITOR_SERVICE = "MonitorServiceRequest";
    private Timer notificationTimer = new Timer(true);
    private String myServerGroup;
    private int currentCapacity = 0;
    private boolean suspended = false;
    private ServiceCapacityCallback serviceCapacityCallback = new ServiceCapacityCallback();

    public BatchReportServerHandler() {
        super(category);
    }

    @Override
    protected int getAffineConnectionsProperty(Configuration configuration) throws NumberFormatException {
        return Integer.parseInt(configuration.getValue("brsAffineConnections"));
    }

    @Override
    protected int getPeakAffineConnectionsProperty(Configuration configuration) throws NumberFormatException {
        return Integer.parseInt(configuration.getValue("brsPeakAffineConnections"));
    }

    @Override
    protected int getNonAffineConnectionsProperty(Configuration configuration) throws NumberFormatException {
        return Integer.parseInt(configuration.getValue("brsNonAffineConnections"));
    }

    @Override
    protected int getPeakNonAffineConnectionsProperty(Configuration configuration) throws NumberFormatException {
        return Integer.parseInt(configuration.getValue("brsPeakNonAffineConnections"));
    }

    @Override
    protected int getMaxProcessProperty(Configuration configuration) throws NumberFormatException {
        return Integer.parseInt(configuration.getValue("brsMaximumProcesses"));
    }

    @Override
    protected int getPeakMaxProcessProperty(Configuration configuration) throws NumberFormatException {
        return Integer.parseInt(configuration.getValue("brsPeakMaximumProcesses"));
    }

    @Override
    protected int getQueueLimitTime(Configuration configuration) throws NumberFormatException {
        return -1;
    }

    @Override
    public String getProcessUseLimitPropertyName() {
        return BATCH_PROCESS_USE_LIMIT;
    }

    @Override
    String getReportServerType() {
        return REPORT_SERVER_MODE_BATCH;
    }

    @Override
    protected int getExecutionTimeLimit(Configuration configuration) throws NumberFormatException {
        return Integer.parseInt(configuration.getValue("brsExecutionTimeLimit"));
    }

    @Override
    protected Date getDataSourceChange(Configuration configuration) throws ParseException {
        return dateFormat.parse(configuration.getValue("brsDataSourceChange"));
    }

    @Override
    protected String getAuditLevel(Configuration configuration) {
        return configuration.getValue("brsAuditLevel");
    }

    @Override
    protected boolean getAuditNativeQuery(Configuration configuration) {
        return Boolean.valueOf(configuration.getValue("brsAuditNativeQuery"));
    }

    @Override
    public void suspend(boolean immediate) {
        ServiceCapacityMediator.getInstance().notify(new ServiceCapacityConfiguration(BATCH_REPORT_SERVICE, this.myServerGroup, 0));
        this.suspended = true;
        super.suspend(immediate);
    }

    @Override
    public void resume() {
        this.inProgressRequests.checkOnce(this.getRequestExpirationTime());
        ServiceCapacityMediator.getInstance().notify(new ServiceCapacityConfiguration(BATCH_REPORT_SERVICE, this.myServerGroup, this.currentCapacity));
        this.suspended = false;
        super.resume();
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        if (!requestEnvelope.isFromService(MONITOR_SERVICE)) {
            mc.setProperty("batchReportServerCapacityConfiguration", this.serviceCapacityCallback);
        }
        super.invokeImpl(mc);
    }

    @Override
    public void notifyCapacity(Configuration configuration, int nonAffineConnections, int maxProcess) {
        this.currentCapacity = maxProcess * nonAffineConnections;
        this.myServerGroup = configuration.getLocalServerGroup();
        if (this.suspended) {
            ServiceCapacityMediator.getInstance().notify(new ServiceCapacityConfiguration(BATCH_REPORT_SERVICE, this.myServerGroup, 0));
        } else {
            this.serviceCapacityCallback.notifyCapacity();
        }
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void stop() {
        ServiceCapacityMediator.getInstance().notify(new ServiceCapacityConfiguration(BATCH_REPORT_SERVICE, this.myServerGroup, 0));
        this.suspended = true;
        this.notificationTimer.cancel();
        super.stop();
    }

    @Override
    protected void registerInteractiveReportMonitor() {
    }

    protected String getServiceName() {
        return BATCH_REPORT_SERVICE;
    }

    ServiceCapacityCallback getServiceCapacityCallback() {
        return this.serviceCapacityCallback;
    }

    public class ServiceCapacityCallback {
        private int capacityAdjustment = 0;

        public synchronized void adjustCapacity(int capacityChange) {
            this.capacityAdjustment += capacityChange;
            this.notifyCapacity();
        }

        public void notifyCapacity() {
            int newCapacity = BatchReportServerHandler.this.currentCapacity + this.capacityAdjustment;
            ServiceCapacityConfiguration serviceCapacityConfiguration = new ServiceCapacityConfiguration(BatchReportServerHandler.BATCH_REPORT_SERVICE, BatchReportServerHandler.this.myServerGroup, newCapacity);
            ServiceCapacityMediator.getInstance().notify(serviceCapacityConfiguration);
        }
    }
}

