/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.SOAPException;
import com.cognos.pogo.pdk.dom4j.Dom4jEnvelope;
import com.cognos.pogo.pdk.stax.StaxEnvelope;
import com.cognos.pogo.util.PogoLogger;
import java.io.ByteArrayInputStream;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class CancelEnvelopeFactory {
    private static final Namespace NS_REPORT_SERVICE = Namespace.get((String)"rs", (String)"http://developer.cognos.com/schemas/reportService/1");
    public static final QName CANCEL = DocumentHelper.createQName((String)"cancel", (Namespace)NS_REPORT_SERVICE);

    public static BIBusEnvelope createCancelEnvelope(BIBusEnvelope responseEnvelope, PogoLogger pogoLogger) {
        if (responseEnvelope instanceof Dom4jEnvelope) {
            return CancelEnvelopeFactory.createCancelEnvelopeFromDOM((Dom4jEnvelope)responseEnvelope, pogoLogger);
        }
        if (responseEnvelope instanceof StaxEnvelope) {
            return CancelEnvelopeFactory.createCancelEnvelopeFromSTAX((StaxEnvelope)responseEnvelope, pogoLogger);
        }
        return null;
    }

    private static BIBusEnvelope createCancelEnvelopeFromSTAX(StaxEnvelope responseEnvelope, PogoLogger pogoLogger) {
        Dom4jEnvelope cancelEnvelope = null;
        try {
            String responseText = responseEnvelope.asXML();
            Document responseDocument = DocumentHelper.parseText((String)responseText);
            Element bodyElement = responseDocument.getRootElement().element("Body");
            bodyElement.detach();
            bodyElement = responseDocument.getRootElement().addElement("Body");
            Element cancelElement = bodyElement.addElement(CANCEL);
            Element conversationElement = cancelElement.addElement("conversation");
            conversationElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":asynchRequest");
            conversationElement.addAttribute(SOAPEnvelope.XSI_NIL, "true");
            ByteArrayInputStream inputStream = new ByteArrayInputStream(responseDocument.asXML().getBytes());
            cancelEnvelope = new Dom4jEnvelope(inputStream);
            pogoLogger.debug("Constructed cancel request: ", cancelEnvelope);
        }
        catch (DocumentException docException) {
            pogoLogger.error(new Object[]{docException});
        }
        catch (SOAPException e) {
            pogoLogger.error(e);
        }
        return cancelEnvelope;
    }

    private static BIBusEnvelope createCancelEnvelopeFromDOM(Dom4jEnvelope responseEnvelope, PogoLogger pogoLogger) {
        BIBusEnvelope cancelEnvelope = new BIBusEnvelope();
        if (responseEnvelope != null) {
            Element headerElement = responseEnvelope.getBIBusHeader();
            headerElement.detach();
            cancelEnvelope.setBIBusHeader(headerElement);
            Element cancelEnvelopeElement = cancelEnvelope.getEnvelope();
            List namespaces = responseEnvelope.getEnvelope().declaredNamespaces();
            for (Namespace aNamespace : namespaces) {
                cancelEnvelopeElement.add(aNamespace);
            }
        }
        Element body = cancelEnvelope.getBody();
        Element cancelElement = body.addElement(CANCEL);
        Element conversationElement = cancelElement.addElement("conversation");
        conversationElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":asynchRequest");
        conversationElement.addAttribute(SOAPEnvelope.XSI_NIL, "true");
        pogoLogger.debug("Constructed cancel request: ", cancelEnvelope);
        return cancelEnvelope;
    }
}

