/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class MapPreviewRequestHandler
extends BasicHandler {
    private static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(MapPreviewRequestHandler.class.getName());
    private static final Namespace NS_RS = DocumentHelper.createNamespace((String)"rs", (String)"http://developer.cognos.com/schemas/reportService/1");
    private static final QName RS_GET_MAP_PREVIEW_METHOD = DocumentHelper.createQName((String)"getMapPreview", (Namespace)NS_RS);
    private static final String SOAPACTION_HEADER = "SOAPAction";
    private static final String REPORT_SERVICE_SOAPACTION = "http://developer.cognos.com/schemas/reportService/1";

    public MapPreviewRequestHandler() {
        super(logger);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        BIBusEnvelope reqEnv = (BIBusEnvelope)mc.getProperty("request.envelope");
        InternetHeaders headers = (InternetHeaders)mc.getProperty("request.headers");
        headers.addHeader(SOAPACTION_HEADER, REPORT_SERVICE_SOAPACTION);
        String mapId = reqEnv.getFormValue("getMapPreview");
        if (mapId == null || mapId.length() == 0) {
            logger.error("malformed map preview request: getMapPreview is missing from URL or has no value.");
            mc.setFault(new Fault("mapPreview.badRequest"));
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Preparing get map preview request body for: " + mapId);
        }
        Element getMapPreviewMethodElem = reqEnv.getBody().addElement(RS_GET_MAP_PREVIEW_METHOD);
        Element idElem = getMapPreviewMethodElem.addElement("id");
        idElem.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.XSD_STRING);
        idElem.addText(mapId);
        if (logger.isDebugEnabled()) {
            logger.debug("generated map preview request body: " + reqEnv.getBody().asXML());
        }
    }
}

